/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.HandlerEvent;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IHandlerListener;

public abstract class AbstractHandler
extends org.eclipse.core.commands.AbstractHandler
implements IHandler {
    private List handlerListeners;

    @Override
    public void addHandlerListener(IHandlerListener iHandlerListener) {
        if (iHandlerListener == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners == null) {
            this.handlerListeners = new ArrayList();
        }
        if (!this.handlerListeners.contains(iHandlerListener)) {
            this.handlerListeners.add(iHandlerListener);
        }
    }

    @Override
    public void dispose() {
    }

    public Object execute(ExecutionEvent executionEvent) throws org.eclipse.core.commands.ExecutionException {
        try {
            return this.execute(executionEvent.getParameters());
        }
        catch (ExecutionException executionException) {
            throw new org.eclipse.core.commands.ExecutionException(executionException.getMessage(), executionException.getCause());
        }
    }

    protected void fireHandlerChanged(org.eclipse.core.commands.HandlerEvent handlerEvent) {
        super.fireHandlerChanged(handlerEvent);
        if (this.handlerListeners != null) {
            Object object;
            HashMap<String, Object> hashMap;
            boolean bl;
            boolean bl2 = bl = handlerEvent.isEnabledChanged() || handlerEvent.isHandledChanged();
            if (bl) {
                hashMap = new HashMap<String, Object>();
                hashMap.putAll(this.getAttributeValuesByName());
                if (handlerEvent.isEnabledChanged()) {
                    object = !this.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                    hashMap.put("enabled", object);
                }
                if (handlerEvent.isHandledChanged()) {
                    object = !this.isHandled() ? Boolean.TRUE : Boolean.FALSE;
                    hashMap.put("handled", object);
                }
            } else {
                hashMap = null;
            }
            object = new HandlerEvent(this, bl, hashMap);
            int n = 0;
            while (n < this.handlerListeners.size()) {
                ((IHandlerListener)this.handlerListeners.get(n)).handlerChanged((HandlerEvent)object);
                ++n;
            }
        }
    }

    protected void fireHandlerChanged(HandlerEvent handlerEvent) {
        int n;
        if (handlerEvent == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners != null) {
            n = 0;
            while (n < this.handlerListeners.size()) {
                ((IHandlerListener)this.handlerListeners.get(n)).handlerChanged(handlerEvent);
                n += 1;
            }
        }
        if (super.hasListeners()) {
            boolean bl;
            Map map;
            if (handlerEvent.haveAttributeValuesByNameChanged()) {
                map = handlerEvent.getPreviousAttributeValuesByName();
                Object v = map.get("enabled");
                n = v instanceof Boolean ? (Boolean)v : 0;
                v = map.get("handled");
                bl = v instanceof Boolean ? (Boolean)v : false;
            } else {
                n = 0;
                bl = true;
            }
            map = new org.eclipse.core.commands.HandlerEvent((org.eclipse.core.commands.IHandler)this, n != 0, bl);
            super.fireHandlerChanged((org.eclipse.core.commands.HandlerEvent)map);
        }
    }

    @Override
    public Map getAttributeValuesByName() {
        return Collections.EMPTY_MAP;
    }

    protected final boolean hasListeners() {
        return super.hasListeners() || this.handlerListeners != null;
    }

    public boolean isEnabled() {
        Object v = this.getAttributeValuesByName().get("enabled");
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return false;
    }

    public boolean isHandled() {
        Object v = this.getAttributeValuesByName().get("handled");
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return false;
    }

    @Override
    public void removeHandlerListener(IHandlerListener iHandlerListener) {
        if (iHandlerListener == null) {
            throw new NullPointerException();
        }
        if (this.handlerListeners == null) {
            return;
        }
        if (this.handlerListeners != null) {
            this.handlerListeners.remove(iHandlerListener);
        }
        if (this.handlerListeners.isEmpty()) {
            this.handlerListeners = null;
        }
    }
}

