/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.EditorAreaHelper;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;

public class WorkbenchWindowAdvisor {
    private IWorkbenchWindowConfigurer windowConfigurer;

    public WorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        Assert.isNotNull((Object)iWorkbenchWindowConfigurer);
        this.windowConfigurer = iWorkbenchWindowConfigurer;
    }

    protected IWorkbenchWindowConfigurer getWindowConfigurer() {
        return this.windowConfigurer;
    }

    public void preWindowOpen() {
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        return new ActionBarAdvisor(iActionBarConfigurer);
    }

    public void postWindowRestore() throws WorkbenchException {
    }

    protected void cleanUpEditorArea() {
        WorkbenchPage workbenchPage;
        EditorAreaHelper editorAreaHelper;
        if (this.getWindowConfigurer() != null && this.getWindowConfigurer().getWindow() != null && this.getWindowConfigurer().getWindow().getActivePage() != null && (editorAreaHelper = (workbenchPage = (WorkbenchPage)this.getWindowConfigurer().getWindow().getActivePage()).getEditorPresentation()) != null) {
            ArrayList arrayList = editorAreaHelper.getWorkbooks();
            int n = 0;
            while (n < arrayList.size()) {
                PartStack partStack = (PartStack)arrayList.get(n);
                if (partStack.getChildren().length == 0) {
                    partStack.getContainer().remove(partStack);
                }
                ++n;
            }
        }
    }

    public void openIntro() {
        IWorkbenchConfigurer iWorkbenchConfigurer = this.getWindowConfigurer().getWorkbenchConfigurer();
        Boolean bl = (Boolean)iWorkbenchConfigurer.getData("introOpened");
        if (bl != null && bl.booleanValue()) {
            return;
        }
        iWorkbenchConfigurer.setData("introOpened", Boolean.TRUE);
        boolean bl2 = PrefUtil.getAPIPreferenceStore().getBoolean("showIntro");
        IIntroManager iIntroManager = iWorkbenchConfigurer.getWorkbench().getIntroManager();
        boolean bl3 = iIntroManager.hasIntro();
        boolean bl4 = iIntroManager.isNewContentAvailable();
        if (bl3 && (bl2 || bl4)) {
            PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
            PrefUtil.saveAPIPrefs();
            iIntroManager.showIntro(this.getWindowConfigurer().getWindow(), false);
        }
    }

    public void postWindowCreate() {
    }

    public void postWindowOpen() {
    }

    public boolean preWindowShellClose() {
        return true;
    }

    public void postWindowClose() {
    }

    public void createWindowContents(Shell shell) {
        ((WorkbenchWindowConfigurer)this.getWindowConfigurer()).createDefaultContents(shell);
    }

    public Control createEmptyWindowContents(Composite composite) {
        return null;
    }

    public boolean isDurableFolder(String string, String string2) {
        return false;
    }

    public void dispose() {
    }

    public IStatus saveState(IMemento iMemento) {
        return Status.OK_STATUS;
    }

    public IStatus restoreState(IMemento iMemento) {
        return Status.OK_STATUS;
    }
}

