/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.application.CompatibilityWorkbenchWindowAdvisor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.model.ContributionComparator;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;

public abstract class WorkbenchAdvisor {
    public static final int FILL_PROXY = 1;
    public static final int FILL_MENU_BAR = 2;
    public static final int FILL_COOL_BAR = 4;
    public static final int FILL_STATUS_LINE = 8;
    private IWorkbenchConfigurer workbenchConfigurer;
    private AbstractStatusHandler workbenchErrorHandler;
    private boolean introOpened;

    protected WorkbenchAdvisor() {
    }

    public final void internalBasicInitialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        if (this.workbenchConfigurer != null) {
            throw new IllegalStateException();
        }
        this.workbenchConfigurer = iWorkbenchConfigurer;
        this.initialize(iWorkbenchConfigurer);
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
    }

    protected IWorkbenchConfigurer getWorkbenchConfigurer() {
        return this.workbenchConfigurer;
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.workbenchErrorHandler == null) {
            this.workbenchErrorHandler = new WorkbenchErrorHandler();
        }
        return this.workbenchErrorHandler;
    }

    public void preStartup() {
    }

    public void postStartup() {
    }

    public boolean preShutdown() {
        return true;
    }

    public void postShutdown() {
    }

    public void eventLoopException(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        try {
            StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, "Unhandled event loop exception", throwable));
            if (WorkbenchPlugin.DEBUG) {
                throwable.printStackTrace();
            }
        }
        catch (Throwable throwable2) {
            System.err.println("Error while logging event loop exception:");
            throwable.printStackTrace();
            System.err.println("Logging exception:");
            throwable2.printStackTrace();
        }
    }

    public void eventLoopIdle(Display display) {
        display.sleep();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new CompatibilityWorkbenchWindowAdvisor(this, iWorkbenchWindowConfigurer);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public void fillActionBars(IWorkbenchWindow iWorkbenchWindow, IActionBarConfigurer iActionBarConfigurer, int n) {
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) throws WorkbenchException {
    }

    public void openIntro(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        if (this.introOpened) {
            return;
        }
        this.introOpened = true;
        boolean bl = PrefUtil.getAPIPreferenceStore().getBoolean("showIntro");
        if (!bl) {
            return;
        }
        if (this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro()) {
            PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
            PrefUtil.saveAPIPrefs();
            this.getWorkbenchConfigurer().getWorkbench().getIntroManager().showIntro(iWorkbenchWindowConfigurer.getWindow(), false);
        }
    }

    public void postWindowCreate(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return true;
    }

    public void postWindowClose(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, String string) {
        return false;
    }

    public IAdaptable getDefaultPageInput() {
        return null;
    }

    public abstract String getInitialWindowPerspectiveId();

    public String getMainPreferencePageId() {
        return null;
    }

    public void createWindowContents(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, Shell shell) {
        ((WorkbenchWindowConfigurer)iWorkbenchWindowConfigurer).createDefaultContents(shell);
    }

    public boolean openWindows() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        final Throwable[] throwableArray = new Throwable[1];
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    UISynchronizer.startupThread.set(Boolean.TRUE);
                    var1_1 = new IWorkbenchConfigurer[1];
                    StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                        @Override
                        public void runWithException() throws Throwable {
                            var1_1[0] = WorkbenchAdvisor.this.getWorkbenchConfigurer();
                        }
                    });
                    var2_3 = var1_1[0].restoreState();
                    if (var2_3.isOK()) ** GOTO lbl13
                    if (var2_3.getCode() == 2) {
                        blArray[0] = false;
                        return;
                    }
                    try {
                        if (var2_3.getCode() == 1) {
                            var1_1[0].openFirstTimeWindow();
                        }
lbl13:
                        // 4 sources

                        blArray[0] = true;
                    }
                    catch (Throwable var1_2) {
                        throwableArray[0] = var1_2;
                    }
                }
                finally {
                    blArray2[0] = true;
                    display.wake();
                }
            }
        };
        thread.start();
        while (true) {
            if (display.readAndDispatch()) {
                continue;
            }
            if (blArray2[0]) break;
            display.sleep();
        }
        if (throwableArray[0] instanceof Error) {
            throw (Error)throwableArray[0];
        }
        if (throwableArray[0] instanceof RuntimeException) {
            throw (RuntimeException)throwableArray[0];
        }
        return blArray[0];
    }

    public IStatus saveState(IMemento iMemento) {
        return Status.OK_STATUS;
    }

    public IStatus restoreState(IMemento iMemento) {
        return Status.OK_STATUS;
    }

    public ContributionComparator getComparatorFor(String string) {
        return new ContributionComparator();
    }
}

