/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ActionBarAdvisor {
    public static final int FILL_PROXY = 1;
    public static final int FILL_MENU_BAR = 2;
    public static final int FILL_COOL_BAR = 4;
    public static final int FILL_STATUS_LINE = 8;
    private IActionBarConfigurer actionBarConfigurer;
    protected Map<String, IAction> actions = new HashMap<String, IAction>();

    public ActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        Assert.isNotNull((Object)iActionBarConfigurer);
        this.actionBarConfigurer = iActionBarConfigurer;
    }

    protected IActionBarConfigurer getActionBarConfigurer() {
        return this.actionBarConfigurer;
    }

    public void fillActionBars(int n) {
        if ((n & 1) == 0) {
            this.makeActions(this.actionBarConfigurer.getWindowConfigurer().getWindow());
        }
        if ((n & 2) != 0) {
            this.fillMenuBar(this.actionBarConfigurer.getMenuManager());
        }
        if ((n & 4) != 0) {
            this.fillCoolBar(this.actionBarConfigurer.getCoolBarManager());
        }
        if ((n & 8) != 0) {
            this.fillStatusLine(this.actionBarConfigurer.getStatusLineManager());
        }
    }

    protected void makeActions(IWorkbenchWindow iWorkbenchWindow) {
    }

    protected void register(IAction iAction) {
        Assert.isNotNull((Object)iAction, (String)"Action must not be null");
        String string = iAction.getId();
        Assert.isNotNull((Object)string, (String)"Action must not have null id");
        this.getActionBarConfigurer().registerGlobalAction(iAction);
        this.actions.put(string, iAction);
    }

    public IAction getAction(String string) {
        return this.actions.get(string);
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
    }

    protected void fillCoolBar(ICoolBarManager iCoolBarManager) {
    }

    protected void fillStatusLine(IStatusLineManager iStatusLineManager) {
    }

    public boolean isApplicationMenu(String string) {
        return false;
    }

    public void dispose() {
        this.disposeActions();
    }

    protected void disposeActions() {
        for (IAction iAction : this.actions.values()) {
            this.disposeAction(iAction);
        }
        this.actions.clear();
    }

    protected void disposeAction(IAction iAction) {
        if (iAction instanceof ActionFactory.IWorkbenchAction) {
            ((ActionFactory.IWorkbenchAction)iAction).dispose();
        }
    }

    public IStatus saveState(IMemento iMemento) {
        return Status.OK_STATUS;
    }

    public IStatus restoreState(IMemento iMemento) {
        return Status.OK_STATUS;
    }
}

