/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.ITriggerPointAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.ws.EnablementDialog;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;

public class WorkbenchTriggerPointAdvisor
implements ITriggerPointAdvisor,
IExecutableExtension {
    public static String PROCEED_MULTI = "proceedMulti";
    public static String PROCEED_SINGLE = "proceedSingle";
    public static String DONT_ASK = "dontAsk";
    public static String NO_DETAILS = "noDetails";
    private Properties strings = new Properties();

    @Override
    public Set allow(ITriggerPoint iTriggerPoint, IIdentifier iIdentifier) {
        if (iTriggerPoint.getBooleanHint("pre_UI")) {
            IActivityManager iActivityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            for (String string : iIdentifier.getActivityIds()) {
                IActivity iActivity = iActivityManager.getActivity(string);
                if (iActivity.getExpression() == null || iActivity.isEnabled()) continue;
                return null;
            }
            return Collections.EMPTY_SET;
        }
        if (!PrefUtil.getInternalPreferenceStore().getBoolean("shouldPromptForEnablement")) {
            return iIdentifier.getActivityIds();
        }
        if (!iTriggerPoint.getBooleanHint("interactive")) {
            return iIdentifier.getActivityIds();
        }
        EnablementDialog enablementDialog = new EnablementDialog(Util.getShellToParentOn(), iIdentifier.getActivityIds(), this.strings);
        if (enablementDialog.open() == 0) {
            Set set = enablementDialog.getActivitiesToEnable();
            if (enablementDialog.getDontAsk()) {
                PrefUtil.getInternalPreferenceStore().setValue("shouldPromptForEnablement", false);
                WorkbenchPlugin.getDefault().savePluginPreferences();
            }
            return set;
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        if (object instanceof Hashtable) {
            this.strings.putAll((Map<?, ?>)((Hashtable)object));
        }
    }

    @Override
    public boolean computeEnablement(IActivityManager iActivityManager, IIdentifier iIdentifier) {
        return this.doComputeEnablement(iActivityManager, iIdentifier, false);
    }

    protected boolean doComputeEnablement(IActivityManager iActivityManager, IIdentifier iIdentifier, boolean bl) {
        Set set = iIdentifier.getActivityIds();
        if (set.size() == 0) {
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string : set) {
            IActivity iActivity = iActivityManager.getActivity(string);
            if (iActivity.isEnabled()) {
                if (!bl) {
                    return true;
                }
                bl2 = true;
                continue;
            }
            if (!bl || iActivity.getExpression() == null) continue;
            bl3 = true;
        }
        return !bl3 && bl2;
    }
}

