/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityRequirementBinding;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.ICategoryActivityBinding;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.ITriggerPointAdvisor;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;

public final class WorkbenchActivityHelper {
    public static final String TRIGGER_PRE_UI_POINT = "org.eclipse.ui.workbenchModel";

    private static ITriggerPoint getTriggerPoint(String string) {
        return PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint(string);
    }

    public static IIdentifier getIdentifier(IPluginContribution iPluginContribution) {
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IIdentifier iIdentifier = iWorkbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(iPluginContribution));
        return iIdentifier;
    }

    public static boolean allowUseOf(Object object) {
        return WorkbenchActivityHelper.allowUseOf(PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.internal.UnknownTriggerPoint"), object);
    }

    public static boolean allowUseOf(ITriggerPoint iTriggerPoint, Object object) {
        if (!WorkbenchActivityHelper.isFiltering()) {
            return true;
        }
        if (iTriggerPoint == null) {
            return true;
        }
        if (object instanceof IPluginContribution) {
            IPluginContribution iPluginContribution = (IPluginContribution)object;
            IIdentifier iIdentifier = WorkbenchActivityHelper.getIdentifier(iPluginContribution);
            return WorkbenchActivityHelper.allow(iTriggerPoint, iIdentifier);
        }
        return true;
    }

    public static boolean restrictUseOf(Object object) {
        return !WorkbenchActivityHelper.allowUseOf(WorkbenchActivityHelper.getTriggerPoint(TRIGGER_PRE_UI_POINT), object);
    }

    private static boolean allow(ITriggerPoint iTriggerPoint, IIdentifier iIdentifier) {
        if (iIdentifier.isEnabled()) {
            return true;
        }
        ITriggerPointAdvisor iTriggerPointAdvisor = ((WorkbenchActivitySupport)PlatformUI.getWorkbench().getActivitySupport()).getTriggerPointAdvisor();
        Set set = iTriggerPointAdvisor.allow(iTriggerPoint, iIdentifier);
        if (set == null) {
            return false;
        }
        if (set.isEmpty()) {
            return true;
        }
        WorkbenchActivityHelper.enableActivities(set);
        Set set2 = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getEnabledActivityIds();
        return set2.containsAll(set);
    }

    public static final String createUnifiedId(IPluginContribution iPluginContribution) {
        if (iPluginContribution.getPluginId() != null) {
            return String.valueOf(iPluginContribution.getPluginId()) + '/' + iPluginContribution.getLocalId();
        }
        return iPluginContribution.getLocalId();
    }

    private static void enableActivities(Collection collection) {
        IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet hashSet = new HashSet(iWorkbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        hashSet.addAll(collection);
        iWorkbenchActivitySupport.setEnabledActivityIds(hashSet);
    }

    public static final boolean filterItem(Object object) {
        if (object instanceof IPluginContribution) {
            IPluginContribution iPluginContribution = (IPluginContribution)object;
            IWorkbenchActivitySupport iWorkbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
            IIdentifier iIdentifier = iWorkbenchActivitySupport.getActivityManager().getIdentifier(WorkbenchActivityHelper.createUnifiedId(iPluginContribution));
            if (!iIdentifier.isEnabled()) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isFiltering() {
        return !PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds().isEmpty();
    }

    public static Set getEnabledCategories(IActivityManager iActivityManager, String string) {
        ICategory iCategory = iActivityManager.getCategory(string);
        if (!iCategory.isDefined()) {
            return Collections.EMPTY_SET;
        }
        Set set = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory));
        HashSet<String> hashSet = new HashSet<String>();
        Set set2 = iActivityManager.getDefinedCategoryIds();
        for (String string2 : set2) {
            if (string2.equals(string)) continue;
            ICategory iCategory2 = iActivityManager.getCategory(string2);
            Set set3 = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory2));
            if (iActivityManager.getEnabledActivityIds().containsAll(set3) || !set.containsAll(set3)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static Set expandActivityDependencies(Set set) {
        HashSet hashSet = new HashSet();
        for (String string : set) {
            Set set2 = WorkbenchActivityHelper.getRequiredActivityIds(string);
            hashSet.addAll(set2);
        }
        hashSet.addAll(set);
        return hashSet;
    }

    public static Set getRequiredActivityIds(String string) {
        IActivityManager iActivityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IActivity iActivity = iActivityManager.getActivity(string);
        if (!iActivity.isDefined()) {
            return Collections.EMPTY_SET;
        }
        Set set = iActivity.getActivityRequirementBindings();
        if (set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> hashSet = new HashSet<String>(3);
        for (IActivityRequirementBinding iActivityRequirementBinding : set) {
            hashSet.add(iActivityRequirementBinding.getRequiredActivityId());
            hashSet.addAll(WorkbenchActivityHelper.getRequiredActivityIds(iActivityRequirementBinding.getRequiredActivityId()));
        }
        return hashSet;
    }

    public static Set getActivityIdsForCategory(ICategory iCategory) {
        Set set = iCategory.getCategoryActivityBindings();
        HashSet<String> hashSet = new HashSet<String>();
        for (ICategoryActivityBinding iCategoryActivityBinding : set) {
            hashSet.add(iCategoryActivityBinding.getActivityId());
        }
        return hashSet;
    }

    public static Set getDisabledCategories(IActivityManager iActivityManager, String string) {
        ICategory iCategory = iActivityManager.getCategory(string);
        if (!iCategory.isDefined()) {
            return Collections.EMPTY_SET;
        }
        Set set = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory));
        HashSet<String> hashSet = new HashSet<String>();
        Set set2 = iActivityManager.getDefinedCategoryIds();
        for (String string2 : set2) {
            ICategory iCategory2;
            Set set3;
            if (string2.equals(string) || (set3 = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory2 = iActivityManager.getCategory(string2)))).isEmpty() || !set.containsAll(set3) || !iActivityManager.getEnabledActivityIds().containsAll(set3)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static final Set getContainedCategories(IActivityManager iActivityManager, String string) {
        ICategory iCategory = iActivityManager.getCategory(string);
        if (!iCategory.isDefined()) {
            return Collections.EMPTY_SET;
        }
        Set set = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory));
        HashSet<String> hashSet = new HashSet<String>();
        Set set2 = iActivityManager.getDefinedCategoryIds();
        for (String string2 : set2) {
            ICategory iCategory2;
            Set set3;
            if (string2.equals(string) || (set3 = WorkbenchActivityHelper.expandActivityDependencies(WorkbenchActivityHelper.getActivityIdsForCategory(iCategory2 = iActivityManager.getCategory(string2)))).isEmpty() || !set.containsAll(set3)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static Set getEnabledCategories(IActivityManager iActivityManager) {
        Set set = iActivityManager.getDefinedCategoryIds();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!WorkbenchActivityHelper.isEnabled(iActivityManager, string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Set getPartiallyEnabledCategories(IActivityManager iActivityManager) {
        Set set = iActivityManager.getDefinedCategoryIds();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!WorkbenchActivityHelper.isPartiallyEnabled(iActivityManager, string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static boolean isPartiallyEnabled(IActivityManager iActivityManager, String string) {
        Set set = WorkbenchActivityHelper.getActivityIdsForCategory(iActivityManager.getCategory(string));
        int n = 0;
        for (String string2 : set) {
            if (!iActivityManager.getEnabledActivityIds().contains(string2)) continue;
            ++n;
        }
        return n > 0 && n != set.size();
    }

    public static Set getEnabledCategoriesForActivity(IActivityManager iActivityManager, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = WorkbenchActivityHelper.getEnabledCategories(iActivityManager);
        for (String string2 : set) {
            if (!WorkbenchActivityHelper.getActivityIdsForCategory(iActivityManager.getCategory(string2)).contains(string)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static boolean isEnabled(IActivityManager iActivityManager, String string) {
        ICategory iCategory = iActivityManager.getCategory(string);
        if (iCategory.isDefined()) {
            Set set = WorkbenchActivityHelper.getActivityIdsForCategory(iCategory);
            if (iActivityManager.getEnabledActivityIds().containsAll(set)) {
                return true;
            }
        }
        return false;
    }

    public static ICategory[] resolveCategories(IMutableActivityManager iMutableActivityManager, Set set) {
        ICategory[] iCategoryArray = new ICategory[set.size()];
        String[] stringArray = set.toArray(new String[set.size()]);
        int n = 0;
        while (n < stringArray.length) {
            iCategoryArray[n] = iMutableActivityManager.getCategory(stringArray[n]);
            ++n;
        }
        return iCategoryArray;
    }

    public static Collection restrictCollection(Collection collection, Collection collection2) {
        for (Object e : collection) {
            if (WorkbenchActivityHelper.restrictUseOf(e)) continue;
            collection2.add(e);
        }
        return collection2;
    }

    public static Object[] restrictArray(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (!WorkbenchActivityHelper.restrictUseOf(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray((Object[])Array.newInstance(objectArray.getClass().getComponentType(), arrayList.size()));
    }

    public static Collection filterCollection(Collection collection, Collection collection2) {
        for (Object e : collection) {
            if (WorkbenchActivityHelper.filterItem(e)) continue;
            collection2.add(e);
        }
        return collection2;
    }

    public static Object[] filterArray(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (!WorkbenchActivityHelper.filterItem(objectArray[n])) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray((Object[])Array.newInstance(objectArray.getClass().getComponentType(), arrayList.size()));
    }

    private WorkbenchActivityHelper() {
    }
}

