/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Set;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.internal.util.Util;

public final class ActivityManagerEvent {
    private IActivityManager activityManager;
    private boolean definedActivityIdsChanged;
    private boolean definedCategoryIdsChanged;
    private boolean enabledActivityIdsChanged;
    private final Set previouslyDefinedActivityIds;
    private final Set previouslyDefinedCategoryIds;
    private final Set previouslyEnabledActivityIds;

    public ActivityManagerEvent(IActivityManager iActivityManager, boolean bl, boolean bl2, boolean bl3, Set set, Set set2, Set set3) {
        if (iActivityManager == null) {
            throw new NullPointerException();
        }
        if (!bl && set != null) {
            throw new IllegalArgumentException();
        }
        if (!bl2 && set2 != null) {
            throw new IllegalArgumentException();
        }
        if (!bl3 && set3 != null) {
            throw new IllegalArgumentException();
        }
        this.previouslyDefinedActivityIds = bl ? Util.safeCopy(set, String.class) : null;
        this.previouslyDefinedCategoryIds = bl2 ? Util.safeCopy(set2, String.class) : null;
        this.previouslyEnabledActivityIds = bl3 ? Util.safeCopy(set3, String.class) : null;
        this.activityManager = iActivityManager;
        this.definedActivityIdsChanged = bl;
        this.definedCategoryIdsChanged = bl2;
        this.enabledActivityIdsChanged = bl3;
    }

    public IActivityManager getActivityManager() {
        return this.activityManager;
    }

    public final Set getPreviouslyDefinedActivityIds() {
        return this.previouslyDefinedActivityIds;
    }

    public final Set getPreviouslyDefinedCategoryIds() {
        return this.previouslyDefinedCategoryIds;
    }

    public final Set getPreviouslyEnabledActivityIds() {
        return this.previouslyEnabledActivityIds;
    }

    public boolean haveDefinedActivityIdsChanged() {
        return this.definedActivityIdsChanged;
    }

    public boolean haveDefinedCategoryIdsChanged() {
        return this.definedCategoryIdsChanged;
    }

    public boolean haveEnabledActivityIdsChanged() {
        return this.enabledActivityIdsChanged;
    }
}

