/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.activities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.NotDefinedException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.activities.InternalActivityHelper;
import org.eclipse.ui.internal.activities.ws.ActivityEnabler;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ActivityCategoryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    public static final String ACTIVITY_NAME = "activityName";
    public static final String ALLOW_ADVANCED = "allowAdvanced";
    public static final String CAPTION_MESSAGE = "captionMessage";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String ACTIVITY_PROMPT_BUTTON = "activityPromptButton";
    public static final String ACTIVITY_PROMPT_BUTTON_TOOLTIP = "activityPromptButtonTooltip";
    protected IWorkbench workbench;
    private CheckboxTableViewer categoryViewer;
    private TableViewer dependantViewer;
    private Text descriptionText;
    private IMutableActivityManager workingCopy;
    private Button activityPromptButton;
    private boolean allowAdvanced = false;
    private Button advancedButton;
    private Properties strings = new Properties();

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(this.strings.getProperty(CAPTION_MESSAGE, ActivityMessages.ActivitiesPreferencePage_captionMessage));
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.createPromptButton(composite2);
        this.createCategoryArea(composite2);
        this.createDetailsArea(composite2);
        this.createButtons(composite2);
        this.workbench.getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.capabilities_preference_page_context");
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void createPromptButton(Composite composite) {
        this.activityPromptButton = new Button(composite, 32);
        this.activityPromptButton.setText(this.strings.getProperty(ACTIVITY_PROMPT_BUTTON, ActivityMessages.activityPromptButton));
        this.activityPromptButton.setToolTipText(this.strings.getProperty(ACTIVITY_PROMPT_BUTTON_TOOLTIP, ActivityMessages.activityPromptToolTip));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.activityPromptButton.setLayoutData((Object)gridData);
        this.activityPromptButton.setSelection(this.getPreferenceStore().getBoolean("shouldPromptForEnablement"));
    }

    private void createButtons(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActivityCategoryPreferencePage.this.workingCopy.setEnabledActivityIds(ActivityCategoryPreferencePage.this.workingCopy.getDefinedActivityIds());
            }
        });
        button.setText(ActivityMessages.ActivityEnabler_selectAll);
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite2, 8);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ActivityCategoryPreferencePage.this.workingCopy.setEnabledActivityIds(Collections.EMPTY_SET);
            }
        });
        button2.setText(ActivityMessages.ActivityEnabler_deselectAll);
        this.setButtonLayoutData(button2);
        if (this.allowAdvanced) {
            Label label = new Label(composite2, 0);
            gridData = new GridData(512);
            label.setLayoutData((Object)gridData);
            this.advancedButton = new Button(composite2, 8);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AdvancedDialog advancedDialog = new AdvancedDialog(composite.getShell());
                    advancedDialog.open();
                }
            });
            this.advancedButton.setText(ActivityMessages.ActivitiesPreferencePage_advancedButton);
            this.setButtonLayoutData(this.advancedButton);
        }
    }

    private void createDetailsArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        new Label(composite2, 0).setText(ActivityMessages.ActivityEnabler_description);
        this.descriptionText = new Text(composite2, 2120);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 100;
        gridData.widthHint = 200;
        this.descriptionText.setLayoutData((Object)gridData);
        new Label(composite2, 0).setText(ActivityMessages.ActivitiesPreferencePage_requirements);
        this.dependantViewer = new TableViewer(composite2, 2048);
        this.dependantViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.dependantViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.dependantViewer.addFilter((ViewerFilter)new EmptyCategoryFilter());
        this.dependantViewer.setLabelProvider((IBaseLabelProvider)new CategoryLabelProvider(false));
        this.dependantViewer.setInput((Object)Collections.EMPTY_SET);
    }

    private void createCategoryArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(String.valueOf(this.strings.getProperty(CATEGORY_NAME, ActivityMessages.ActivityEnabler_categories)) + ':');
        Table table = new Table(composite2, 2084);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 32) {
                    TableItem tableItem = (TableItem)selectionEvent.item;
                    ICategory iCategory = (ICategory)tableItem.getData();
                    if (ActivityCategoryPreferencePage.this.isLocked(iCategory)) {
                        tableItem.setChecked(true);
                        selectionEvent.doit = false;
                        return;
                    }
                    HashSet hashSet = WorkbenchActivityHelper.getActivityIdsForCategory(iCategory);
                    if (tableItem.getChecked()) {
                        hashSet.addAll(ActivityCategoryPreferencePage.this.workingCopy.getEnabledActivityIds());
                    } else {
                        HashSet hashSet2 = new HashSet(ActivityCategoryPreferencePage.this.workingCopy.getEnabledActivityIds());
                        hashSet2.removeAll(hashSet);
                        hashSet = hashSet2;
                    }
                    ActivityCategoryPreferencePage.this.workingCopy.setEnabledActivityIds(hashSet);
                    ActivityCategoryPreferencePage.this.updateCategoryCheckState();
                }
            }
        });
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        CategoryLabelProvider categoryLabelProvider = new CategoryLabelProvider(true);
        this.workingCopy.addActivityManagerListener(categoryLabelProvider);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)categoryLabelProvider);
        this.categoryViewer.setComparator(new ViewerComparator());
        this.categoryViewer.addFilter((ViewerFilter)new EmptyCategoryFilter());
        this.categoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ICategory iCategory = (ICategory)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                ActivityCategoryPreferencePage.this.setDetails(iCategory);
            }
        });
        this.categoryViewer.setInput((Object)this.workingCopy.getDefinedCategoryIds());
        this.updateCategoryCheckState();
    }

    private void updateCategoryCheckState() {
        ICategory[] iCategoryArray = this.getEnabledCategories();
        Object[] objectArray = this.getPartialCategories();
        Object[] objectArray2 = new Object[iCategoryArray.length + objectArray.length];
        System.arraycopy(iCategoryArray, 0, objectArray2, 0, iCategoryArray.length);
        System.arraycopy(objectArray, 0, objectArray2, iCategoryArray.length, objectArray.length);
        this.categoryViewer.setCheckedElements(objectArray2);
        this.categoryViewer.setGrayedElements(objectArray);
    }

    private ICategory[] getPartialCategories() {
        return WorkbenchActivityHelper.resolveCategories(this.workingCopy, InternalActivityHelper.getPartiallyEnabledCategories(this.workingCopy));
    }

    private ICategory[] getEnabledCategories() {
        return WorkbenchActivityHelper.resolveCategories(this.workingCopy, InternalActivityHelper.getEnabledCategories(this.workingCopy));
    }

    protected void setDetails(ICategory iCategory) {
        if (iCategory == null) {
            this.clearDetails();
            return;
        }
        Set set = null;
        set = WorkbenchActivityHelper.isEnabled(this.workingCopy, iCategory.getId()) ? WorkbenchActivityHelper.getDisabledCategories(this.workingCopy, iCategory.getId()) : WorkbenchActivityHelper.getEnabledCategories(this.workingCopy, iCategory.getId());
        set = WorkbenchActivityHelper.getContainedCategories(this.workingCopy, iCategory.getId());
        this.dependantViewer.setInput((Object)set);
        try {
            this.descriptionText.setText(iCategory.getDescription());
        }
        catch (NotDefinedException notDefinedException) {
            this.descriptionText.setText("");
        }
    }

    protected void clearDetails() {
        this.dependantViewer.setInput((Object)Collections.EMPTY_SET);
        this.descriptionText.setText("");
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.workingCopy = iWorkbench.getActivitySupport().createWorkingCopy();
        this.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
    }

    protected boolean isLocked(ICategory iCategory) {
        return !WorkbenchActivityHelper.getDisabledCategories(this.workingCopy, iCategory.getId()).isEmpty();
    }

    public boolean performOk() {
        this.workbench.getActivitySupport().setEnabledActivityIds(this.workingCopy.getEnabledActivityIds());
        this.getPreferenceStore().setValue("shouldPromptForEnablement", this.activityPromptButton.getSelection());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.activityPromptButton.setSelection(this.getPreferenceStore().getDefaultBoolean("shouldPromptForEnablement"));
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.workingCopy.getDefinedActivityIds();
        for (String string : set) {
            IActivity iActivity = this.workingCopy.getActivity(string);
            try {
                if (!iActivity.isDefaultEnabled()) continue;
                hashSet.add(string);
            }
            catch (NotDefinedException notDefinedException) {}
        }
        this.workingCopy.setEnabledActivityIds(hashSet);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.allowAdvanced = Boolean.valueOf((String)hashtable.remove(ALLOW_ADVANCED));
            this.strings.putAll((Map<?, ?>)hashtable);
        }
    }

    public void dispose() {
        if (this.workingCopy != null) {
            this.workingCopy.removeActivityManagerListener((CategoryLabelProvider)this.categoryViewer.getLabelProvider());
        }
        super.dispose();
    }

    private class AdvancedDialog
    extends TrayDialog {
        private static final String DIALOG_SETTINGS_SECTION = "ActivityCategoryPreferencePageAdvancedDialogSettings";
        ActivityEnabler enabler;

        protected AdvancedDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String string = ActivityCategoryPreferencePage.this.strings.getProperty(ActivityCategoryPreferencePage.ACTIVITY_NAME, ActivityMessages.ActivityEnabler_activities);
            string = Util.replaceAll((String)string, (String)"&", (String)"");
            shell.setText(NLS.bind((String)ActivityMessages.ActivitiesPreferencePage_advancedDialogTitle, (Object)string));
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.enabler = new ActivityEnabler(ActivityCategoryPreferencePage.this.workingCopy, ActivityCategoryPreferencePage.this.strings);
            Control control = this.enabler.createControl(composite2);
            control.setLayoutData((Object)new GridData(1808));
            return composite2;
        }

        protected void okPressed() {
            this.enabler.updateActivityStates();
            super.okPressed();
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
            }
            return iDialogSettings2;
        }

        protected boolean isResizable() {
            return true;
        }
    }

    private class CategoryContentProvider
    implements IStructuredContentProvider {
        private CategoryContentProvider() {
        }

        public Object[] getElements(Object object) {
            return WorkbenchActivityHelper.resolveCategories(ActivityCategoryPreferencePage.this.workingCopy, (Set)object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IActivityManagerListener {
        private LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources());
        private ImageDescriptor lockDescriptor;
        private boolean decorate;

        public CategoryLabelProvider(boolean bl) {
            this.decorate = bl;
            this.lockDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.ui", "icons/full/ovr16/lock_ovr.gif");
        }

        public Image getColumnImage(Object object, int n) {
            ICategory iCategory = (ICategory)object;
            ImageDescriptor imageDescriptor = PlatformUI.getWorkbench().getActivitySupport().getImageDescriptor(iCategory);
            if (imageDescriptor != null) {
                try {
                    if (this.decorate && ActivityCategoryPreferencePage.this.isLocked(iCategory)) {
                        ImageData imageData = imageDescriptor.getImageData();
                        OverlayIcon overlayIcon = new OverlayIcon(imageDescriptor, this.lockDescriptor, new Point(imageData.width, imageData.height));
                        return this.manager.createImage((ImageDescriptor)overlayIcon);
                    }
                    return this.manager.createImage(imageDescriptor);
                }
                catch (DeviceResourceException deviceResourceException) {
                    WorkbenchPlugin.log(deviceResourceException);
                }
            }
            return null;
        }

        public String getText(Object object) {
            String string = null;
            ICategory iCategory = (ICategory)object;
            try {
                string = iCategory.getName();
            }
            catch (NotDefinedException notDefinedException) {
                string = iCategory.getId();
            }
            if (this.decorate && ActivityCategoryPreferencePage.this.isLocked(iCategory)) {
                string = NLS.bind((String)ActivityMessages.ActivitiesPreferencePage_lockedMessage, (Object)string);
            }
            return string;
        }

        public String getColumnText(Object object, int n) {
            return this.getText(object);
        }

        public void dispose() {
            super.dispose();
            this.manager.dispose();
        }

        @Override
        public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
            if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                ActivityCategoryPreferencePage.this.updateCategoryCheckState();
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
            }
        }
    }

    private class EmptyCategoryFilter
    extends ViewerFilter {
        private EmptyCategoryFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            ICategory iCategory = (ICategory)object2;
            return !InternalActivityHelper.getActivityIdsForCategory(ActivityCategoryPreferencePage.this.workingCopy, iCategory).isEmpty();
        }
    }
}

