/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.WorkingSetMenuContributionItem;
import org.eclipse.ui.internal.actions.ClearWorkingSetAction;
import org.eclipse.ui.internal.actions.EditWorkingSetAction;
import org.eclipse.ui.internal.actions.SelectWorkingSetAction;
import org.eclipse.ui.internal.util.Util;

public class WorkingSetFilterActionGroup
extends ActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    public static final String CHANGE_WORKING_SET = "changeWorkingSet";
    private static final String START_SEPARATOR_ID = "workingSetGroupStartSeparator";
    private static final String SEPARATOR_ID = "workingSetGroupSeparator";
    private static final String WORKING_SET_ACTION_GROUP = "workingSetActionGroup";
    private IWorkingSet workingSet = null;
    private ClearWorkingSetAction clearWorkingSetAction;
    private SelectWorkingSetAction selectWorkingSetAction;
    private EditWorkingSetAction editWorkingSetAction;
    private IPropertyChangeListener workingSetUpdater;
    private IWorkbenchWindow workbenchWindow;
    private IWorkbenchPage page;
    private boolean allowWindowWorkingSetByDefault;
    private CompoundContributionItem mruList;

    public WorkingSetFilterActionGroup(Shell shell, IPropertyChangeListener iPropertyChangeListener) {
        IWorkbenchPage[] iWorkbenchPageArray;
        Assert.isNotNull((Object)shell);
        this.workingSetUpdater = iPropertyChangeListener;
        this.clearWorkingSetAction = new ClearWorkingSetAction(this);
        this.selectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.editWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.mruList = new CompoundContributionItem(){

            @Override
            protected IContributionItem[] getContributionItems() {
                IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
                ArrayList<WorkingSetMenuContributionItem> arrayList = new ArrayList<WorkingSetMenuContributionItem>(iWorkingSetArray.length);
                List<IWorkingSet> list = Arrays.asList(iWorkingSetArray);
                Collections.sort(list, new WorkingSetComparator());
                int n = 0;
                for (IWorkingSet iWorkingSet : list) {
                    if (iWorkingSet == null) continue;
                    WorkingSetMenuContributionItem workingSetMenuContributionItem = new WorkingSetMenuContributionItem(++n, WorkingSetFilterActionGroup.this, iWorkingSet);
                    arrayList.add(workingSetMenuContributionItem);
                }
                return arrayList.toArray(new IContributionItem[arrayList.size()]);
            }
        };
        this.workbenchWindow = Util.getWorkbenchWindowForShell(shell);
        this.allowWindowWorkingSetByDefault = false;
        this.page = this.workbenchWindow.getActivePage();
        if (this.page == null && (iWorkbenchPageArray = this.workbenchWindow.getPages()).length > 0) {
            this.page = iWorkbenchPageArray[0];
        }
    }

    @Override
    public void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        if (iMenuManager.find("additions") != null) {
            iMenuManager.insertAfter("additions", (IContributionItem)new Separator(WORKING_SET_ACTION_GROUP));
        } else {
            iMenuManager.add((IContributionItem)new Separator(WORKING_SET_ACTION_GROUP));
        }
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IAction)this.selectWorkingSetAction);
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IAction)this.clearWorkingSetAction);
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IAction)this.editWorkingSetAction);
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IContributionItem)new Separator(START_SEPARATOR_ID));
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IContributionItem)this.mruList);
        iMenuManager.appendToGroup(WORKING_SET_ACTION_GROUP, (IContributionItem)new Separator(SEPARATOR_ID));
    }

    @Override
    public void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.selectWorkingSetAction);
        iMenuManager.add((IAction)this.clearWorkingSetAction);
        iMenuManager.add((IAction)this.editWorkingSetAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)this.mruList);
        iMenuManager.add((IContributionItem)new Separator(SEPARATOR_ID));
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        IWorkingSet iWorkingSet2 = this.workingSet;
        this.workingSet = iWorkingSet;
        this.clearWorkingSetAction.setEnabled(iWorkingSet != null);
        this.editWorkingSetAction.setEnabled(iWorkingSet != null && iWorkingSet.isEditable());
        this.firePropertyChange(iWorkingSet, iWorkingSet2);
    }

    private void firePropertyChange(IWorkingSet iWorkingSet, IWorkingSet iWorkingSet2) {
        if (this.workingSetUpdater != null) {
            this.workingSetUpdater.propertyChange(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET, (Object)iWorkingSet2, (Object)iWorkingSet));
        }
    }

    public void saveState(IMemento iMemento) {
        if (this.workingSet != null) {
            iMemento.putString(TAG_WORKING_SET_NAME, this.workingSet.getName());
        } else {
            iMemento.putString(TAG_WORKING_SET_NAME, "");
        }
    }

    public void restoreState(IMemento iMemento) {
        String string = iMemento.getString(TAG_WORKING_SET_NAME);
        if (string != null && string.length() > 0) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string));
        } else if (this.page != null && this.useWindowWorkingSetByDefault()) {
            this.setWorkingSet(this.page.getAggregateWorkingSet());
        }
    }

    private boolean useWindowWorkingSetByDefault() {
        return this.allowWindowWorkingSetByDefault && PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT");
    }
}

