/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.internal.PartSite;

public class RetargetAction
extends PartEventAction
implements ActionFactory.IWorkbenchAction {
    private HelpListener localHelpListener;
    private boolean enableAccelerator = true;
    private IAction handler;
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RetargetAction.this.propagateChange(propertyChangeEvent);
        }
    };

    public RetargetAction(String string, String string2) {
        this(string, string2, 0);
    }

    public RetargetAction(String string, String string2, int n) {
        super(string2, n);
        this.setId(string);
        this.setEnabled(false);
        super.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                HelpListener helpListener = null;
                if (RetargetAction.this.handler != null && (helpListener = RetargetAction.this.handler.getHelpListener()) == null) {
                    helpListener = RetargetAction.this.localHelpListener;
                }
                if (helpListener != null) {
                    helpListener.helpRequested(helpEvent);
                }
            }
        });
    }

    @Override
    public void dispose() {
        IWorkbenchPart iWorkbenchPart;
        if (this.handler != null) {
            this.handler.removePropertyChangeListener(this.propertyChangeListener);
            this.handler = null;
        }
        if ((iWorkbenchPart = this.getActivePart()) != null) {
            IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
            SubActionBars subActionBars = (SubActionBars)((PartSite)iWorkbenchPartSite).getActionBars();
            subActionBars.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void enableAccelerator(boolean bl) {
        this.enableAccelerator = bl;
    }

    public int getAccelerator() {
        if (this.enableAccelerator) {
            return super.getAccelerator();
        }
        return 0;
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        SubActionBars subActionBars = (SubActionBars)((PartSite)iWorkbenchPartSite).getActionBars();
        subActionBars.addPropertyChangeListener(this.propertyChangeListener);
        this.setActionHandler(subActionBars.getGlobalActionHandler(this.getId()));
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        IWorkbenchPart iWorkbenchPart2 = iWorkbenchPart.getSite().getPage().getActivePart();
        if (iWorkbenchPart2 != null) {
            return;
        }
        if (iWorkbenchPart == this.getActivePart()) {
            this.setActionHandler(null);
        }
        super.partClosed(iWorkbenchPart);
    }

    @Override
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        super.partDeactivated(iWorkbenchPart);
        IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchPart.getSite();
        SubActionBars subActionBars = (SubActionBars)((PartSite)iWorkbenchPartSite).getActionBars();
        subActionBars.removePropertyChangeListener(this.propertyChangeListener);
        IWorkbenchPart iWorkbenchPart2 = iWorkbenchPart.getSite().getPage().getActivePart();
        if (iWorkbenchPart2 != null) {
            return;
        }
        this.setActionHandler(null);
    }

    protected void propagateChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("enabled")) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setEnabled(bl);
        } else if (propertyChangeEvent.getProperty().equals("checked")) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.setChecked(bl);
        } else if (propertyChangeEvent.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && propertyChangeEvent.getSource() instanceof IActionBars) {
            IActionBars iActionBars = (IActionBars)propertyChangeEvent.getSource();
            this.setActionHandler(iActionBars.getGlobalActionHandler(this.getId()));
        }
    }

    public void run() {
        if (this.handler != null) {
            this.handler.run();
        }
    }

    public void runWithEvent(Event event) {
        if (this.handler != null) {
            this.handler.runWithEvent(event);
        }
    }

    public IAction getActionHandler() {
        return this.handler;
    }

    public final boolean isHandled() {
        return this.handler != null;
    }

    protected void setActionHandler(IAction iAction) {
        if (iAction == this.handler) {
            return;
        }
        if (this.handler != null) {
            this.handler.removePropertyChangeListener(this.propertyChangeListener);
            this.handler = null;
        }
        IAction iAction2 = this.handler;
        this.handler = iAction;
        if (this.handler == null) {
            this.setEnabled(false);
            if (this.getStyle() == 2 || this.getStyle() == 8) {
                this.setChecked(false);
            }
        } else {
            this.setEnabled(this.handler.isEnabled());
            if (this.getStyle() == 2 || this.getStyle() == 8) {
                this.setChecked(this.handler.isChecked());
            }
            this.handler.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange("handled", iAction2, iAction);
    }

    public void setChecked(boolean bl) {
        super.setChecked(bl);
        if (this.handler != null) {
            this.handler.setChecked(bl);
        }
    }

    public void setHelpListener(HelpListener helpListener) {
        this.localHelpListener = helpListener;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RetargetAction(");
        stringBuffer.append(this.getId());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

