/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class QuickMenuCreator {
    private static final int CHAR_INDENT = 3;

    public void createMenu() {
        final Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Control control = display.getFocusControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillMenu((IMenuManager)menuManager);
        final Menu menu = menuManager.createContextMenu((Control)control.getShell());
        Point point = this.computeMenuLocation(control);
        if (point == null) {
            return;
        }
        menu.setLocation(point);
        menu.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!menu.isDisposed()) {
                                menu.dispose();
                            }
                        }
                    });
                }
            }
        });
        menu.setVisible(true);
    }

    protected abstract void fillMenu(IMenuManager var1);

    protected Point computeMenuLocation(Control control) {
        StyledText styledText;
        Point point = control.getDisplay().getCursorLocation();
        Rectangle rectangle = null;
        Point point2 = null;
        if (control instanceof StyledText) {
            styledText = (StyledText)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation(styledText);
        } else if (control instanceof Tree) {
            styledText = (Tree)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation((Tree)styledText);
        } else if (control instanceof Table) {
            styledText = (Table)control;
            rectangle = styledText.getClientArea();
            point2 = this.computeMenuLocation((Table)styledText);
        }
        if (point2 == null) {
            point2 = control.toControl(point);
        }
        if (rectangle != null && !rectangle.contains(point2)) {
            point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
        if (!(styledText = control.getShell().getClientArea()).contains(control.getShell().toControl(control.toDisplay(point2)))) {
            point2 = new Point(styledText.x + styledText.width / 2, styledText.y + styledText.height / 2);
        }
        return control.toDisplay(point2);
    }

    protected Point computeMenuLocation(StyledText styledText) {
        Point point = styledText.getLocationAtOffset(styledText.getCaretOffset());
        point.y += styledText.getLineHeight(styledText.getCaretOffset());
        if (!styledText.getClientArea().contains(point)) {
            return null;
        }
        return point;
    }

    protected Point computeMenuLocation(Tree tree) {
        TreeItem[] treeItemArray = tree.getSelection();
        Rectangle rectangle = tree.getClientArea();
        switch (treeItemArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                Rectangle rectangle2 = treeItemArray[0].getBounds();
                Rectangle rectangle3 = rectangle.intersection(rectangle2);
                if (rectangle3 != null && rectangle3.height == rectangle2.height) {
                    return new Point(Math.max(0, rectangle2.x + this.getAvarageCharWith((Control)tree) * 3), rectangle2.y + rectangle2.height);
                }
                return null;
            }
        }
        Rectangle[] rectangleArray = new Rectangle[treeItemArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            rectangleArray[n] = treeItemArray[n].getBounds();
            ++n;
        }
        Point point = tree.getDisplay().getCursorLocation();
        Point point2 = this.findBestLocation(this.getIncludedPositions(rectangleArray, rectangle), tree.toControl(point));
        if (point2 != null) {
            point2.x += this.getAvarageCharWith((Control)tree) * 3;
        }
        return point2;
    }

    protected Point computeMenuLocation(Table table) {
        TableItem[] tableItemArray = table.getSelection();
        Rectangle rectangle = table.getClientArea();
        switch (tableItemArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                Rectangle rectangle2 = tableItemArray[0].getBounds(0);
                Rectangle rectangle3 = tableItemArray[0].getImageBounds(0);
                Rectangle rectangle4 = rectangle.intersection(rectangle2);
                if (rectangle4 != null && rectangle4.height == rectangle2.height) {
                    return new Point(Math.max(0, rectangle2.x + rectangle3.width + this.getAvarageCharWith((Control)table) * 3), rectangle2.y + rectangle2.height);
                }
                return null;
            }
        }
        Rectangle[] rectangleArray = new Rectangle[tableItemArray.length];
        int n = 0;
        while (n < rectangleArray.length) {
            rectangleArray[n] = tableItemArray[n].getBounds(0);
            ++n;
        }
        Rectangle rectangle5 = tableItemArray[0].getImageBounds(0);
        Point point = table.getDisplay().getCursorLocation();
        Point point2 = this.findBestLocation(this.getIncludedPositions(rectangleArray, rectangle), table.toControl(point));
        if (point2 != null) {
            point2.x = point2.x + rectangle5.width + this.getAvarageCharWith((Control)table) * 3;
        }
        return point2;
    }

    private Point[] getIncludedPositions(Rectangle[] rectangleArray, Rectangle rectangle) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle2 = rectangleArray[n];
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            if (rectangle3 != null && rectangle3.height == rectangle2.height) {
                arrayList.add(new Point(rectangle3.x, rectangle3.y + rectangle3.height));
            }
            ++n;
        }
        return arrayList.toArray(new Point[arrayList.size()]);
    }

    private Point findBestLocation(Point[] pointArray, Point point) {
        Point point2 = null;
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < pointArray.length) {
            Point point3 = pointArray[n];
            int n2 = 0;
            int n3 = 0;
            n2 = point3.x > point.x ? point3.x - point.x : point.x - point3.x;
            double d2 = Math.sqrt(n2 * n2 + (n3 = point3.y > point.y ? point3.y - point.y : point.y - point3.y) * n3);
            if (d2 < d) {
                point2 = point3;
                d = d2;
            }
            ++n;
        }
        return point2;
    }

    private int getAvarageCharWith(Control control) {
        GC gC = null;
        try {
            gC = new GC((Drawable)control);
            int n = gC.getFontMetrics().getAverageCharWidth();
            return n;
        }
        finally {
            if (gC != null) {
                gC.dispose();
            }
        }
    }

    public void dispose() {
    }
}

