/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.OpenPerspectiveAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class PerspectiveMenu
extends ContributionItem {
    protected static final String SHOW_PERSP_ID = "org.eclipse.ui.perspectives.showPerspective";
    private IPerspectiveRegistry reg;
    private IWorkbenchWindow window;
    private boolean showActive = false;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            PerspectiveMenu.this.dirty = true;
        }
    };
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)object;
            IPerspectiveDescriptor iPerspectiveDescriptor2 = (IPerspectiveDescriptor)object2;
            return this.collator.compare(iPerspectiveDescriptor.getLabel(), iPerspectiveDescriptor2.getLabel());
        }
    };
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoPerspectives;
    private Map actions = new HashMap();
    private Action openOtherAction = new Action(WorkbenchMessages.PerspectiveMenu_otherItem){

        public final void runWithEvent(Event event) {
            PerspectiveMenu.this.runOther(new SelectionEvent(event));
        }
    };

    public PerspectiveMenu(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(string);
        this.window = iWorkbenchWindow;
        this.reg = iWorkbenchWindow.getWorkbench().getPerspectiveRegistry();
        this.openOtherAction.setActionDefinitionId(SHOW_PERSP_ID);
    }

    public void fill(Menu menu, int n) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager menuManager = new MenuManager();
        this.fillMenu(menuManager);
        IContributionItem[] iContributionItemArray = menuManager.getItems();
        if (iContributionItemArray.length == 0) {
            MenuItem menuItem = new MenuItem(menu, 0, n++);
            menuItem.setText(NO_TARGETS_MSG);
            menuItem.setEnabled(false);
        } else {
            int n2 = 0;
            while (n2 < iContributionItemArray.length) {
                iContributionItemArray[n2].fill(menu, n++);
                ++n2;
            }
        }
        this.dirty = false;
    }

    private final void fillMenu(MenuManager menuManager) {
        menuManager.removeAll();
        ArrayList arrayList = this.getPerspectiveItems();
        Collections.sort(arrayList, this.comparator);
        ArrayList<IAction> arrayList2 = new ArrayList<IAction>(arrayList.size());
        for (IPerspectiveDescriptor iPerspectiveDescriptor : arrayList) {
            IAction iAction = this.getAction(iPerspectiveDescriptor.getId());
            if (iAction == null || WorkbenchActivityHelper.filterItem(iAction)) continue;
            arrayList2.add(iAction);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            menuManager.add((IAction)iterator.next());
        }
        if (PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_OTHER_IN_PERSPECTIVE_MENU")) {
            if (arrayList2.size() > 0) {
                menuManager.add((IContributionItem)new Separator());
            }
            menuManager.add((IAction)this.openOtherAction);
        }
    }

    private final IAction getAction(String string) {
        IPerspectiveDescriptor iPerspectiveDescriptor;
        Object object = (IAction)this.actions.get(string);
        if (object == null && (iPerspectiveDescriptor = this.reg.findPerspectiveWithId(string)) != null) {
            object = new OpenPerspectiveAction(this.window, iPerspectiveDescriptor, this);
            object.setActionDefinitionId(string);
            this.actions.put(string, object);
        }
        return object;
    }

    private ArrayList getPerspectiveShortcuts() {
        ArrayList<IPerspectiveDescriptor> arrayList = new ArrayList<IPerspectiveDescriptor>();
        IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage == null) {
            return arrayList;
        }
        String[] stringArray = iWorkbenchPage.getPerspectiveShortcuts();
        int n = 0;
        while (n < stringArray.length) {
            IPerspectiveDescriptor iPerspectiveDescriptor = this.reg.findPerspectiveWithId(stringArray[n]);
            if (iPerspectiveDescriptor != null && !arrayList.contains(iPerspectiveDescriptor) && !WorkbenchActivityHelper.filterItem(iPerspectiveDescriptor)) {
                arrayList.add(iPerspectiveDescriptor);
            }
            ++n;
        }
        return arrayList;
    }

    protected ArrayList getPerspectiveItems() {
        ArrayList arrayList = this.getPerspectiveShortcuts();
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            if (!arrayList2.contains(arrayList.get(n2))) {
                arrayList2.add(arrayList.get(n2));
            }
            ++n2;
        }
        return arrayList2;
    }

    protected boolean getShowActive() {
        return this.showActive;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    protected abstract void run(IPerspectiveDescriptor var1);

    protected void run(IPerspectiveDescriptor iPerspectiveDescriptor, SelectionEvent selectionEvent) {
        this.run(iPerspectiveDescriptor);
    }

    void runOther(SelectionEvent selectionEvent) {
        IHandlerService iHandlerService = (IHandlerService)this.window.getService(IHandlerService.class);
        try {
            iHandlerService.executeCommand(SHOW_PERSP_ID, null);
        }
        catch (ExecutionException executionException) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)executionException));
        }
        catch (NotDefinedException notDefinedException) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)notDefinedException));
        }
        catch (NotEnabledException notEnabledException) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)notEnabledException));
        }
        catch (NotHandledException notHandledException) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Failed to execute org.eclipse.ui.perspectives.showPerspective", (Throwable)notHandledException));
        }
    }

    protected void showActive(boolean bl) {
        this.showActive = bl;
    }
}

