/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.PerspectiveMenu;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.PrefUtil;

public class OpenPerspectiveMenu
extends PerspectiveMenu {
    private IAdaptable pageInput;
    private IMenuManager parentMenuManager;
    private boolean replaceEnabled = true;
    private static String PAGE_PROBLEMS_TITLE = WorkbenchMessages.OpenPerspectiveMenu_pageProblemsTitle;
    private static String PAGE_PROBLEMS_MESSAGE = WorkbenchMessages.OpenPerspectiveMenu_errorUnknownInput;

    public OpenPerspectiveMenu(IMenuManager iMenuManager, IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow);
        this.parentMenuManager = iMenuManager;
    }

    public OpenPerspectiveMenu(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, (IAdaptable)null);
        this.showActive(true);
    }

    public OpenPerspectiveMenu(IWorkbenchWindow iWorkbenchWindow, IAdaptable iAdaptable) {
        super(iWorkbenchWindow, "Open New Page Menu");
        this.pageInput = iAdaptable;
    }

    private boolean canRun() {
        if (this.openPerspectiveSetting().equals("OPEN_PERSPECTIVE_REPLACE")) {
            return this.replaceEnabled;
        }
        return true;
    }

    private String openPerspectiveSetting() {
        return PrefUtil.getAPIPreferenceStore().getString("OPEN_NEW_PERSPECTIVE");
    }

    @Override
    protected void run(IPerspectiveDescriptor iPerspectiveDescriptor) {
        this.openPage(iPerspectiveDescriptor, 0);
    }

    @Override
    protected void run(IPerspectiveDescriptor iPerspectiveDescriptor, SelectionEvent selectionEvent) {
        this.openPage(iPerspectiveDescriptor, selectionEvent.stateMask);
    }

    private void openPage(IPerspectiveDescriptor iPerspectiveDescriptor, int n) {
        if (this.pageInput == null) {
            StatusUtil.handleStatus(String.valueOf(PAGE_PROBLEMS_TITLE) + ": " + PAGE_PROBLEMS_MESSAGE, 2);
            return;
        }
        try {
            this.getWindow().getWorkbench().showPerspective(iPerspectiveDescriptor.getId(), this.getWindow(), this.pageInput);
        }
        catch (WorkbenchException workbenchException) {
            StatusUtil.handleStatus(String.valueOf(PAGE_PROBLEMS_TITLE) + ": " + workbenchException.getMessage(), (Throwable)((Object)workbenchException), 2);
        }
    }

    public void setPageInput(IAdaptable iAdaptable) {
        this.pageInput = iAdaptable;
    }

    public void setReplaceEnabled(boolean bl) {
        if (this.replaceEnabled != bl) {
            this.replaceEnabled = bl;
            if (this.canRun() && this.parentMenuManager != null) {
                this.parentMenuManager.update(true);
            }
        }
    }
}

