/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StatusUtil;

public class OpenInNewWindowAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;
    private IAdaptable pageInput;

    public OpenInNewWindowAction(IWorkbenchWindow iWorkbenchWindow) {
        this(iWorkbenchWindow, ((Workbench)iWorkbenchWindow.getWorkbench()).getDefaultPageInput());
        this.setActionDefinitionId("org.eclipse.ui.window.newWindow");
    }

    public OpenInNewWindowAction(IWorkbenchWindow iWorkbenchWindow, IAdaptable iAdaptable) {
        super(WorkbenchMessages.OpenInNewWindowAction_text);
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = iWorkbenchWindow;
        this.setToolTipText(WorkbenchMessages.OpenInNewWindowAction_toolTip);
        this.pageInput = iAdaptable;
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.open_new_window_action_context");
    }

    public void setPageInput(IAdaptable iAdaptable) {
        this.pageInput = iAdaptable;
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        try {
            IWorkbenchPage iWorkbenchPage = this.workbenchWindow.getActivePage();
            String string = iWorkbenchPage != null && iWorkbenchPage.getPerspective() != null ? iWorkbenchPage.getPerspective().getId() : this.workbenchWindow.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
            this.workbenchWindow.getWorkbench().openWorkbenchWindow(string, this.pageInput);
        }
        catch (WorkbenchException workbenchException) {
            StatusUtil.handleStatus(workbenchException.getStatus(), String.valueOf(WorkbenchMessages.OpenInNewWindowAction_errorTitle) + ": " + workbenchException.getMessage(), 2);
        }
    }

    @Override
    public void dispose() {
        this.workbenchWindow = null;
    }
}

