/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.PerspectiveTracker;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.NewWizard;
import org.eclipse.ui.internal.util.Util;

public class NewWizardAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private String categoryId = null;
    private String windowTitle = null;
    private IWorkbenchWindow workbenchWindow;
    private PerspectiveTracker tracker;

    public NewWizardAction(IWorkbenchWindow iWorkbenchWindow) {
        super(WorkbenchMessages.NewWizardAction_text);
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = iWorkbenchWindow;
        this.tracker = new PerspectiveTracker(iWorkbenchWindow, this);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(WorkbenchMessages.NewWizardAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.new_action_context");
    }

    public NewWizardAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String string) {
        this.categoryId = string;
    }

    public void setWizardWindowTitle(String string) {
        this.windowTitle = string;
    }

    public void run() {
        IEditorInput iEditorInput;
        Object object;
        IWorkbenchPart iWorkbenchPart;
        Class clazz;
        if (this.workbenchWindow == null) {
            return;
        }
        NewWizard newWizard = new NewWizard();
        newWizard.setCategoryId(this.categoryId);
        newWizard.setWindowTitle(this.windowTitle);
        ISelection iSelection = this.workbenchWindow.getSelectionService().getSelection();
        StructuredSelection structuredSelection = StructuredSelection.EMPTY;
        if (iSelection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)iSelection;
        } else {
            clazz = LegacyResourceSupport.getResourceClass();
            if (clazz != null && (iWorkbenchPart = this.workbenchWindow.getPartService().getActivePart()) instanceof IEditorPart && (object = Util.getAdapter(iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput(), clazz)) != null) {
                structuredSelection = new StructuredSelection(object);
            }
        }
        newWizard.init(this.workbenchWindow.getWorkbench(), (IStructuredSelection)structuredSelection);
        clazz = WorkbenchPlugin.getDefault().getDialogSettings();
        iWorkbenchPart = clazz.getSection("NewWizardAction");
        if (iWorkbenchPart == null) {
            iWorkbenchPart = clazz.addNewSection("NewWizardAction");
        }
        newWizard.setDialogSettings((IDialogSettings)iWorkbenchPart);
        newWizard.setForcePreviousAndNextButtons(true);
        iEditorInput = this.workbenchWindow.getShell();
        object = new WizardDialog((Shell)iEditorInput, (IWizard)newWizard);
        object.create();
        object.getShell().setSize(Math.max(500, object.getShell().getSize().x), 500);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)object.getShell(), "org.eclipse.ui.new_wizard_context");
        object.open();
    }

    @Override
    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.tracker.dispose();
        this.workbenchWindow = null;
    }
}

