/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.actions.RetargetAction;

public class LabelRetargetAction
extends RetargetAction {
    private String defaultText;
    private String defaultToolTipText;
    private ImageDescriptor defaultHoverImage;
    private ImageDescriptor defaultImage;
    private ImageDescriptor defaultDisabledImage;
    private String acceleratorText;

    public LabelRetargetAction(String string, String string2) {
        this(string, string2, 0);
    }

    public LabelRetargetAction(String string, String string2, int n) {
        super(string, string2, n);
        this.defaultText = string2;
        this.defaultToolTipText = string2;
        this.acceleratorText = LegacyActionTools.extractAcceleratorText((String)string2);
    }

    @Override
    protected void propagateChange(PropertyChangeEvent propertyChangeEvent) {
        super.propagateChange(propertyChangeEvent);
        String string = propertyChangeEvent.getProperty();
        if (string.equals("text")) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            super.setText(this.appendAccelerator(string2));
        } else if (string.equals("toolTipText")) {
            String string3 = (String)propertyChangeEvent.getNewValue();
            super.setToolTipText(string3);
        } else if (string.equals("image")) {
            this.updateImages(this.getActionHandler());
        }
    }

    @Override
    protected void setActionHandler(IAction iAction) {
        super.setActionHandler(iAction);
        if (iAction == null) {
            super.setText(this.defaultText);
            super.setToolTipText(this.defaultToolTipText);
        } else {
            String string = iAction.getText();
            if (string == null || string.length() == 0) {
                string = this.defaultText;
            }
            super.setText(this.appendAccelerator(string));
            super.setToolTipText(iAction.getToolTipText());
        }
        this.updateImages(iAction);
    }

    public void setDisabledImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setDisabledImageDescriptor(imageDescriptor);
        this.defaultDisabledImage = imageDescriptor;
    }

    public void setHoverImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setHoverImageDescriptor(imageDescriptor);
        this.defaultHoverImage = imageDescriptor;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        super.setImageDescriptor(imageDescriptor);
        this.defaultImage = imageDescriptor;
    }

    public void setText(String string) {
        super.setText(string);
        this.acceleratorText = LegacyActionTools.extractAcceleratorText((String)string);
        this.defaultText = string;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.defaultToolTipText = string;
    }

    private String appendAccelerator(String string) {
        if (string == null) {
            return null;
        }
        String string2 = LabelRetargetAction.removeAcceleratorText((String)string);
        if (this.acceleratorText != null) {
            string2 = String.valueOf(string2) + this.acceleratorText;
        }
        return string2;
    }

    private void updateImages(IAction iAction) {
        if (iAction == null) {
            super.setHoverImageDescriptor(this.defaultHoverImage);
            super.setImageDescriptor(this.defaultImage);
            super.setDisabledImageDescriptor(this.defaultDisabledImage);
        } else {
            ImageDescriptor imageDescriptor = iAction.getHoverImageDescriptor();
            ImageDescriptor imageDescriptor2 = iAction.getImageDescriptor();
            ImageDescriptor imageDescriptor3 = iAction.getDisabledImageDescriptor();
            if (imageDescriptor != null || imageDescriptor2 != null || imageDescriptor3 != null) {
                super.setHoverImageDescriptor(imageDescriptor);
                super.setImageDescriptor(imageDescriptor2);
                super.setDisabledImageDescriptor(imageDescriptor3);
            } else {
                super.setHoverImageDescriptor(this.defaultHoverImage);
                super.setImageDescriptor(this.defaultImage);
                super.setDisabledImageDescriptor(this.defaultDisabledImage);
            }
        }
    }
}

