/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.ChangeToPerspectiveMenu;
import org.eclipse.ui.internal.ReopenEditorMenu;
import org.eclipse.ui.internal.ShowInMenu;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.internal.SwitchToWindowMenu;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.HelpSearchContributionItem;
import org.eclipse.ui.internal.tweaklets.TabBehaviour;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

public abstract class ContributionItemFactory {
    private final String contributionItemId;
    public static final ContributionItemFactory PIN_EDITOR = new ContributionItemFactory("pinEditor"){
        private static final String COMMAND_ID = "org.eclipse.ui.window.pinEditor";

        @Override
        public IContributionItem create(final IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter(iWorkbenchWindow, COMMAND_ID, COMMAND_ID, null, WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR"), WorkbenchImages.getImageDescriptor("IMG_ETOOL_PIN_EDITOR_DISABLED"), null, null, null, null, 32, null, false);
            final IPropertyChangeListener[] iPropertyChangeListenerArray = new IPropertyChangeListener[1];
            final IPartListener iPartListener = new IPartListener(){

                @Override
                public void partOpened(IWorkbenchPart iWorkbenchPart) {
                }

                @Override
                public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
                }

                @Override
                public void partClosed(IWorkbenchPart iWorkbenchPart) {
                }

                @Override
                public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
                    if (!(iWorkbenchPart instanceof IEditorPart)) {
                        return;
                    }
                    ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
                    iCommandService.refreshElements(1.COMMAND_ID, null);
                }

                @Override
                public void partActivated(IWorkbenchPart iWorkbenchPart) {
                }
            };
            iWorkbenchWindow.getPartService().addPartListener(iPartListener);
            final CommandContributionItem commandContributionItem = new CommandContributionItem(commandContributionItemParameter){

                @Override
                public void dispose() {
                    WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(iPropertyChangeListenerArray[0]);
                    iWorkbenchWindow.getPartService().removePartListener(iPartListener);
                    super.dispose();
                }
            };
            iPropertyChangeListenerArray[0] = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && commandContributionItem.getParent() != null) {
                        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
                        boolean bl = iPreferenceStore.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN") || ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).alwaysShowPinAction();
                        commandContributionItem.setVisible(bl);
                        commandContributionItem.getParent().markDirty();
                        if (iWorkbenchWindow.getShell() != null && !iWorkbenchWindow.getShell().isDisposed()) {
                            iWorkbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    commandContributionItem.getParent().update(false);
                                }
                            });
                        }
                    }
                }
            };
            WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(iPropertyChangeListenerArray[0]);
            commandContributionItem.setVisible(WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN") || ((TabBehaviour)Tweaklets.get(TabBehaviour.KEY)).alwaysShowPinAction());
            return commandContributionItem;
        }
    };
    public static final ContributionItemFactory OPEN_WINDOWS = new ContributionItemFactory("openWindows"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new SwitchToWindowMenu(iWorkbenchWindow, this.getId(), true);
        }
    };
    public static final ContributionItemFactory VIEWS_SHORTLIST = new ContributionItemFactory("viewsShortlist"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new ShowViewMenu(iWorkbenchWindow, this.getId());
        }
    };
    public static final ContributionItemFactory VIEWS_SHOW_IN = new ContributionItemFactory("viewsShowIn"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            ShowInMenu showInMenu = new ShowInMenu();
            showInMenu.setId(this.getId());
            showInMenu.initialize(iWorkbenchWindow);
            return showInMenu;
        }
    };
    public static final ContributionItemFactory REOPEN_EDITORS = new ContributionItemFactory("reopenEditors"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new ReopenEditorMenu(iWorkbenchWindow, this.getId(), true);
        }
    };
    public static final ContributionItemFactory PERSPECTIVES_SHORTLIST = new ContributionItemFactory("perspectivesShortlist"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new ChangeToPerspectiveMenu(iWorkbenchWindow, this.getId());
        }
    };
    public static final ContributionItemFactory NEW_WIZARD_SHORTLIST = new ContributionItemFactory("newWizardShortlist"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new BaseNewWizardMenu(iWorkbenchWindow, this.getId());
        }
    };
    public static final ContributionItemFactory HELP_SEARCH = new ContributionItemFactory("helpSearch"){

        @Override
        public IContributionItem create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            return new HelpSearchContributionItem(iWorkbenchWindow, this.getId());
        }
    };

    protected ContributionItemFactory(String string) {
        this.contributionItemId = string;
    }

    public abstract IContributionItem create(IWorkbenchWindow var1);

    public String getId() {
        return this.contributionItemId;
    }
}

