/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class CompoundContributionItem
extends ContributionItem {
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            CompoundContributionItem.this.dirty = true;
        }
    };
    private IContributionItem[] oldItems;

    protected CompoundContributionItem() {
    }

    protected CompoundContributionItem(String string) {
        super(string);
    }

    public void fill(Menu menu, int n) {
        if (n == -1) {
            n = menu.getItemCount();
        }
        if (!this.dirty && menu.getParentItem() != null) {
            new MenuItem(menu, 0, n);
            return;
        }
        IContributionItem[] iContributionItemArray = this.getContributionItemsToFill();
        int n2 = 0;
        while (n2 < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            int n3 = menu.getItemCount();
            if (iContributionItem.isVisible()) {
                iContributionItem.fill(menu, n);
            }
            int n4 = menu.getItemCount();
            int n5 = n4 - n3;
            n += n5;
            ++n2;
        }
        this.dirty = false;
    }

    protected abstract IContributionItem[] getContributionItems();

    private IContributionItem[] getContributionItemsToFill() {
        this.disposeOldItems();
        this.oldItems = this.getContributionItems();
        return this.oldItems;
    }

    private void disposeOldItems() {
        if (this.oldItems != null) {
            int n = 0;
            while (n < this.oldItems.length) {
                IContributionItem iContributionItem = this.oldItems[n];
                iContributionItem.dispose();
                ++n;
            }
            this.oldItems = null;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        this.disposeOldItems();
        super.dispose();
    }

    public void setParent(IContributionManager iContributionManager) {
        IMenuManager iMenuManager;
        if (this.getParent() instanceof IMenuManager) {
            iMenuManager = (IMenuManager)this.getParent();
            iMenuManager.removeMenuListener(this.menuListener);
        }
        if (iContributionManager instanceof IMenuManager) {
            iMenuManager = (IMenuManager)iContributionManager;
            iMenuManager.addMenuListener(this.menuListener);
        }
        super.setParent(iContributionManager);
    }
}

