/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;

public abstract class BaseSelectionListenerAction
extends Action
implements ISelectionChangedListener {
    private IStructuredSelection selection = new StructuredSelection();
    private boolean running = false;
    private IStructuredSelection deferredSelection = null;

    protected BaseSelectionListenerAction(String string) {
        super(string);
    }

    protected void clearCache() {
    }

    public IStructuredSelection getStructuredSelection() {
        return this.selection;
    }

    public final void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (this.running) {
            this.deferredSelection = iStructuredSelection;
            return;
        }
        this.selection = iStructuredSelection;
        this.clearCache();
        this.setEnabled(this.updateSelection(iStructuredSelection));
    }

    public final void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)iSelection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return true;
    }

    public void runWithEvent(Event event) {
        this.running = true;
        try {
            this.run();
        }
        finally {
            this.running = false;
            IStructuredSelection iStructuredSelection = this.deferredSelection;
            this.deferredSelection = null;
            if (iStructuredSelection != null) {
                this.selectionChanged(iStructuredSelection);
            }
        }
    }
}

