/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class BaseNewWizardMenu
extends CompoundContributionItem {
    private final Map actions = new HashMap(21);
    private final IExtensionChangeHandler configListener = new IExtensionChangeHandler(){

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof NewWizardShortcutAction) {
                    BaseNewWizardMenu.this.actions.values().remove(objectArray[n]);
                }
                ++n;
            }
        }

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        }
    };
    private final IRegistryChangeListener registryListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
            if (BaseNewWizardMenu.this.getParent() != null) {
                BaseNewWizardMenu.this.getParent().markDirty();
            }
        }
    };
    private ActionFactory.IWorkbenchAction showDlgAction;
    private IWorkbenchWindow workbenchWindow;

    public BaseNewWizardMenu(IWorkbenchWindow iWorkbenchWindow, String string) {
        super(string);
        Assert.isNotNull((Object)iWorkbenchWindow);
        this.workbenchWindow = iWorkbenchWindow;
        this.showDlgAction = ActionFactory.NEW.create(iWorkbenchWindow);
        this.registerListeners();
        if (iWorkbenchWindow instanceof WorkbenchWindow) {
            ((WorkbenchWindow)iWorkbenchWindow).addSubmenu(4);
        }
    }

    protected void addItems(List list) {
        if (this.addShortcuts(list)) {
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    protected boolean addShortcuts(List list) {
        boolean bl = false;
        IWorkbenchPage iWorkbenchPage = this.workbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            String[] stringArray = iWorkbenchPage.getNewWizardShortcuts();
            int n = 0;
            while (n < stringArray.length) {
                IAction iAction = this.getAction(stringArray[n]);
                if (iAction != null && !WorkbenchActivityHelper.filterItem(iAction)) {
                    list.add(new ActionContributionItem(iAction));
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    @Override
    public void dispose() {
        if (this.workbenchWindow != null) {
            super.dispose();
            this.unregisterListeners();
            this.showDlgAction.dispose();
            this.showDlgAction = null;
            this.workbenchWindow = null;
        }
    }

    private IAction getAction(String string) {
        IWizardDescriptor iWizardDescriptor;
        Object object = (IAction)this.actions.get(string);
        if (object == null && (iWizardDescriptor = WorkbenchPlugin.getDefault().getNewWizardRegistry().findWizard(string)) != null) {
            object = new NewWizardShortcutAction(this.workbenchWindow, iWizardDescriptor);
            this.actions.put(string, object);
            IConfigurationElement iConfigurationElement = (IConfigurationElement)Util.getAdapter(iWizardDescriptor, IConfigurationElement.class);
            if (iConfigurationElement != null) {
                this.workbenchWindow.getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), object, 2);
            }
        }
        return object;
    }

    @Override
    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> arrayList = new ArrayList<ActionContributionItem>();
        if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null && this.workbenchWindow.getActivePage().getPerspective() != null) {
            this.addItems(arrayList);
        } else {
            String string = WorkbenchMessages.Workbench_noApplicableItems;
            Action action = new Action(string){};
            action.setEnabled(false);
            arrayList.add(new ActionContributionItem((IAction)action));
        }
        return arrayList.toArray(new IContributionItem[arrayList.size()]);
    }

    protected IAction getShowDialogAction() {
        return this.showDlgAction;
    }

    protected IWorkbenchWindow getWindow() {
        return this.workbenchWindow;
    }

    private void registerListeners() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this.registryListener);
        this.workbenchWindow.getExtensionTracker().registerHandler(this.configListener, null);
    }

    protected boolean registryHasCategory(String string) {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory(string) != null;
    }

    private void unregisterListeners() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.registryListener);
        this.workbenchWindow.getExtensionTracker().unregisterHandler(this.configListener);
    }
}

