/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.NewWizardDropDownAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.CloseAllSavedAction;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.ToggleEditorsVisibilityAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public abstract class ActionFactory {
    public static final ActionFactory ABOUT = new ActionFactory("about", "org.eclipse.ui.help.aboutAction"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            IProduct iProduct = Platform.getProduct();
            String string = null;
            if (iProduct != null) {
                string = iProduct.getName();
            }
            if (string == null) {
                string = "";
            }
            workbenchCommandAction.setText(NLS.bind((String)WorkbenchMessages.AboutAction_text, (Object)string));
            workbenchCommandAction.setToolTipText(NLS.bind((String)WorkbenchMessages.AboutAction_toolTip, (Object)string));
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.about_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory ACTIVATE_EDITOR = new ActionFactory("activateEditor", "org.eclipse.ui.window.activateEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ActivateEditorAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ActivateEditorAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory BACK = new ActionFactory("back", "org.eclipse.ui.navigate.back"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_back);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_backToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory BACKWARD_HISTORY = new ActionFactory("backardHistory", "org.eclipse.ui.navigate.backwardHistory"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction navigationHistoryAction = new NavigationHistoryAction(iWorkbenchWindow, false);
            navigationHistoryAction.setId(this.getId());
            return navigationHistoryAction;
        }
    };
    public static final ActionFactory CLOSE = new ActionFactory("close", "org.eclipse.ui.file.close"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CloseEditorAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CloseEditorAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory CLOSE_ALL = new ActionFactory("closeAll", "org.eclipse.ui.file.closeAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CloseAllAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CloseAllAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory CLOSE_OTHERS = new ActionFactory("closeOthers", "org.eclipse.ui.file.closeOthers"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CloseOthersAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CloseOthersAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory CLOSE_ALL_PERSPECTIVES = new ActionFactory("closeAllPerspectives", "org.eclipse.ui.window.closeAllPerspectives"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CloseAllPerspectivesAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CloseAllPerspectivesAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.close_all_pages_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory CLOSE_ALL_SAVED = new ActionFactory("closeAllSaved"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            CloseAllSavedAction closeAllSavedAction = new CloseAllSavedAction(iWorkbenchWindow);
            closeAllSavedAction.setId(this.getId());
            return closeAllSavedAction;
        }
    };
    public static final ActionFactory CLOSE_PERSPECTIVE = new ActionFactory("closePerspective", "org.eclipse.ui.window.closePerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ClosePerspectiveAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ClosePerspectiveAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.close_page_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory INTRO = new ActionFactory("intro", "org.eclipse.ui.help.quickStartAction"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(IntroMessages.Intro_action_text);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.intro_action_context");
            IntroDescriptor introDescriptor = ((Workbench)iWorkbenchWindow.getWorkbench()).getIntroDescriptor();
            if (introDescriptor != null) {
                workbenchCommandAction.setImageDescriptor(introDescriptor.getImageDescriptor());
            }
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory COPY = new ActionFactory("copy", "org.eclipse.ui.edit.copy"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_copy);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            retargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            retargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            return retargetAction;
        }
    };
    public static final ActionFactory CUT = new ActionFactory("cut", "org.eclipse.ui.edit.cut"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_cut);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            retargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            retargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            return retargetAction;
        }
    };
    public static final ActionFactory DELETE = new ActionFactory("delete", "org.eclipse.ui.edit.delete"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_delete);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_deleteToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            retargetAction.enableAccelerator(false);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(retargetAction, "org.eclipse.ui.delete_retarget_action_context");
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            retargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            retargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            return retargetAction;
        }
    };
    public static final ActionFactory EDIT_ACTION_SETS = new ActionFactory("editActionSets", "org.eclipse.ui.window.customizePerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.EditActionSetsAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.EditActionSetsAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.edit_action_sets_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory EXPORT = new ActionFactory("export", "org.eclipse.ui.file.export"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ExportResourcesAction_fileMenuText);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ExportResourcesAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.export_action_context");
            workbenchCommandAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory FIND = new ActionFactory("find", "org.eclipse.ui.edit.findReplace"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_findReplace);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_findReplaceToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory FORWARD = new ActionFactory("forward", "org.eclipse.ui.navigate.forward"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_forward);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_forwardToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory FORWARD_HISTORY = new ActionFactory("forwardHistory", "org.eclipse.ui.navigate.forwardHistory"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction navigationHistoryAction = new NavigationHistoryAction(iWorkbenchWindow, true);
            navigationHistoryAction.setId(this.getId());
            return navigationHistoryAction;
        }
    };
    public static final ActionFactory GO_INTO = new ActionFactory("goInto", "org.eclipse.ui.navigate.goInto"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_goInto);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_goIntoToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory IMPORT = new ActionFactory("import", "org.eclipse.ui.file.import"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ImportResourcesAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ImportResourcesAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.import_action_context");
            workbenchCommandAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_IMPORT_WIZ"));
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory LOCK_TOOL_BAR = new ActionFactory("lockToolBar", "org.eclipse.ui.window.lockToolBar"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.LockToolBarAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.LockToolBarAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.lock_toolbar_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory MAXIMIZE = new ActionFactory("maximize", "org.eclipse.ui.window.maximizePart"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setToolTipText(WorkbenchMessages.MaximizePartAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.maximize_part_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory MINIMIZE = new ActionFactory("minimize", "org.eclipse.ui.window.minimizePart"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setToolTipText(WorkbenchMessages.MinimizePartAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.minimize_part_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory MOVE = new ActionFactory("move", "org.eclipse.ui.edit.move"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_move);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_moveToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory NEW = new ActionFactory("new", "org.eclipse.ui.newWizard"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            workbenchCommandAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
            workbenchCommandAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
            workbenchCommandAction.setText(WorkbenchMessages.NewWizardAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.NewWizardAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.new_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory NEW_WIZARD_DROP_DOWN = new ActionFactory("newWizardDropDown"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            NewWizardDropDownAction newWizardDropDownAction = new NewWizardDropDownAction(iWorkbenchWindow);
            newWizardDropDownAction.setId(this.getId());
            return newWizardDropDownAction;
        }
    };
    public static final ActionFactory NEXT = new ActionFactory("next", "org.eclipse.ui.navigate.next"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_next);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_nextToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory NEXT_EDITOR = new ActionFactory("nextEditor", "org.eclipse.ui.window.nextEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CycleEditorAction_next_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CycleEditorAction_next_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_editor_forward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory NEXT_PART = new ActionFactory("nextPart", "org.eclipse.ui.window.nextView"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CyclePartAction_next_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CyclePartAction_next_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_part_forward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory NEXT_PERSPECTIVE = new ActionFactory("nextPerspective", "org.eclipse.ui.window.nextPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CyclePerspectiveAction_next_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_next_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_perspective_forward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory OPEN_NEW_WINDOW = new ActionFactory("openNewWindow", "org.eclipse.ui.window.newWindow"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.OpenInNewWindowAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.OpenInNewWindowAction_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.open_new_window_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory PASTE = new ActionFactory("paste", "org.eclipse.ui.edit.paste"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_paste);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            retargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            retargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            return retargetAction;
        }
    };
    public static final ActionFactory PREFERENCES = new ActionFactory("openPrefs", "com.deltawalker.ui.openPrefs"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.OpenPreferences_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.OpenPreferences_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.open_preferences_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory PREVIOUS = new ActionFactory("previous", "org.eclipse.ui.navigate.previous"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_previous);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_previousToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory PREVIOUS_EDITOR = new ActionFactory("previousEditor", "org.eclipse.ui.window.previousEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CycleEditorAction_prev_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CycleEditorAction_prev_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_editor_backward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory PREVIOUS_PART = new ActionFactory("previousPart", "org.eclipse.ui.window.previousView"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CyclePartAction_prev_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CyclePartAction_prev_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_part_backward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory PREVIOUS_PERSPECTIVE = new ActionFactory("previousPerspective", "org.eclipse.ui.window.previousPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.CyclePerspectiveAction_prev_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_prev_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.cycle_perspective_backward_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory PRINT = new ActionFactory("print", "org.eclipse.ui.file.print"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_print);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_printToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            retargetAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT"));
            retargetAction.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));
            return retargetAction;
        }
    };
    public static final ActionFactory PROPERTIES = new ActionFactory("properties", "org.eclipse.ui.file.properties"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_properties);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_propertiesToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory QUIT = new ActionFactory("quit", "org.eclipse.ui.file.exit"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.Exit_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.Exit_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.quit_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory REDO = new ActionFactory("redo", "org.eclipse.ui.edit.redo"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_redo);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_redoToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            labelRetargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            labelRetargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
            return labelRetargetAction;
        }
    };
    public static final ActionFactory REFRESH = new ActionFactory("refresh", "org.eclipse.ui.file.refresh"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_refresh);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_refreshToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory RENAME = new ActionFactory("rename", "org.eclipse.ui.edit.rename"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_rename);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_renameToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory RESET_PERSPECTIVE = new ActionFactory("resetPerspective", "org.eclipse.ui.window.resetPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ResetPerspective_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ResetPerspective_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.reset_perspective_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory REVERT = new ActionFactory("revert", "org.eclipse.ui.file.revert"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_revert);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_revertToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory SAVE = new ActionFactory("save", "org.eclipse.ui.file.save"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setText(WorkbenchMessages.SaveAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.SaveAction_toolTip);
            workbenchCommandAction.setId(this.getId());
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.save_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SAVE_ALL = new ActionFactory("saveAll", "org.eclipse.ui.file.saveAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setText(WorkbenchMessages.SaveAll_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.SaveAll_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.save_all_action_context");
            workbenchCommandAction.setId(this.getId());
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SAVE_AS = new ActionFactory("saveAs", "org.eclipse.ui.file.saveAs"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setText(WorkbenchMessages.SaveAs_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.SaveAs_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.save_as_action_context");
            workbenchCommandAction.setId(this.getId());
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SAVE_PERSPECTIVE = new ActionFactory("savePerspective", "org.eclipse.ui.window.savePerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.SavePerspective_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.SavePerspective_toolTip);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.save_perspective_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SELECT_ALL = new ActionFactory("selectAll", "org.eclipse.ui.edit.selectAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction retargetAction = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_selectAll);
            retargetAction.setToolTipText(WorkbenchMessages.Workbench_selectAllToolTip);
            iWorkbenchWindow.getPartService().addPartListener(retargetAction);
            retargetAction.setActionDefinitionId(this.getCommandId());
            return retargetAction;
        }
    };
    public static final ActionFactory SHOW_EDITOR = new ActionFactory("showEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            ToggleEditorsVisibilityAction toggleEditorsVisibilityAction = new ToggleEditorsVisibilityAction(iWorkbenchWindow);
            toggleEditorsVisibilityAction.setId(this.getId());
            return toggleEditorsVisibilityAction;
        }
    };
    public static final ActionFactory SHOW_OPEN_EDITORS = new ActionFactory("showOpenEditors"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction("org.eclipse.ui.window.switchToEditor", iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.WorkbenchEditorsAction_label);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.workbench_editors_action_context");
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SHOW_WORKBOOK_EDITORS = new ActionFactory("showWorkBookEditors"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction("org.eclipse.ui.window.openEditorDropDown", iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.WorkbookEditorsAction_label);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SHOW_QUICK_ACCESS = new ActionFactory("showQuickAccess"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction("org.eclipse.ui.window.quickAccess", iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.QuickAccessAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.QuickAccessAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SHOW_PART_PANE_MENU = new ActionFactory("showPartPaneMenu"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction("org.eclipse.ui.window.showSystemMenu", iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ShowPartPaneMenuAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ShowPartPaneMenuAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory SHOW_VIEW_MENU = new ActionFactory("showViewMenu", "org.eclipse.ui.window.showViewMenu"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ShowViewMenuAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ShowViewMenuAction_toolTip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory UNDO = new ActionFactory("undo", "org.eclipse.ui.edit.undo"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_undo);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_undoToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            ISharedImages iSharedImages = iWorkbenchWindow.getWorkbench().getSharedImages();
            labelRetargetAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            labelRetargetAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
            return labelRetargetAction;
        }
    };
    public static final ActionFactory UP = new ActionFactory("up", "org.eclipse.ui.navigate.up"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction labelRetargetAction = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_up);
            labelRetargetAction.setToolTipText(WorkbenchMessages.Workbench_upToolTip);
            iWorkbenchWindow.getPartService().addPartListener(labelRetargetAction);
            labelRetargetAction.setActionDefinitionId(this.getCommandId());
            return labelRetargetAction;
        }
    };
    public static final ActionFactory HELP_CONTENTS = new ActionFactory("helpContents", "org.eclipse.ui.help.helpContents"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            String string = PrefUtil.getAPIPreferenceStore().getString("helpContentsActionText");
            if ("".equals(string)) {
                workbenchCommandAction.setText(WorkbenchMessages.HelpContentsAction_text);
                workbenchCommandAction.setToolTipText(WorkbenchMessages.HelpContentsAction_toolTip);
            } else {
                workbenchCommandAction.setText(string);
                workbenchCommandAction.setToolTipText(Action.removeMnemonics((String)string));
            }
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.help_contents_action_context");
            workbenchCommandAction.setId(this.getId());
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory HELP_SEARCH = new ActionFactory("helpSearch", "org.eclipse.ui.help.helpSearch"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            String string = PrefUtil.getAPIPreferenceStore().getString("helpSearchActionText");
            if ("".equals(string)) {
                workbenchCommandAction.setText(WorkbenchMessages.HelpSearchAction_text);
                workbenchCommandAction.setToolTipText(WorkbenchMessages.HelpSearchAction_toolTip);
            } else {
                workbenchCommandAction.setText(string);
                workbenchCommandAction.setToolTipText(Action.removeMnemonics((String)string));
            }
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.help_search_action_context");
            workbenchCommandAction.setId(this.getId());
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory DYNAMIC_HELP = new ActionFactory("dynamicHelp", "org.eclipse.ui.help.dynamicHelp"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            String string = PrefUtil.getAPIPreferenceStore().getString("dynamicHelpActionText");
            if ("".equals(string)) {
                workbenchCommandAction.setText(WorkbenchMessages.DynamicHelpAction_text);
                workbenchCommandAction.setToolTipText(WorkbenchMessages.DynamicHelpAction_toolTip);
            } else {
                workbenchCommandAction.setText(string);
                workbenchCommandAction.setToolTipText(Action.removeMnemonics((String)string));
            }
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp(workbenchCommandAction, "org.eclipse.ui.dynamic_help_action_context");
            workbenchCommandAction.setId(this.getId());
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory OPEN_PERSPECTIVE_DIALOG = new ActionFactory("openPerspectiveDialog", "org.eclipse.ui.perspectives.showPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.OpenPerspectiveDialogAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
            workbenchCommandAction.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE"));
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory NEW_EDITOR = new ActionFactory("newEditor", "com.deltawalker.ui.file.compareFiles"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction(this.getCommandId(), iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.NewEditorAction_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.NewEditorAction_tooltip);
            return workbenchCommandAction;
        }
    };
    public static final ActionFactory TOGGLE_COOLBAR = new ActionFactory("toggleCoolbar"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction workbenchCommandAction = new WorkbenchCommandAction("org.eclipse.ui.ToggleCoolbarAction", iWorkbenchWindow);
            workbenchCommandAction.setId(this.getId());
            workbenchCommandAction.setText(WorkbenchMessages.ToggleCoolbarVisibilityAction_hide_text);
            workbenchCommandAction.setToolTipText(WorkbenchMessages.ToggleCoolbarVisibilityAction_toolTip);
            return workbenchCommandAction;
        }
    };
    private final String actionId;
    private final String commandId;

    public static void linkCycleActionPair(IWorkbenchAction iWorkbenchAction, IWorkbenchAction iWorkbenchAction2) {
    }

    protected ActionFactory(String string) {
        this(string, null);
    }

    protected ActionFactory(String string, String string2) {
        this.actionId = string;
        this.commandId = string2;
    }

    public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow) {
        Assert.isTrue((boolean)false);
        return null;
    }

    public IWorkbenchAction create(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getId() {
        return this.actionId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public static interface IWorkbenchAction
    extends IAction {
        public void dispose();
    }

    public static class WorkbenchCommandAction
    extends CommandAction
    implements IWorkbenchAction {
        public WorkbenchCommandAction(String string, IWorkbenchWindow iWorkbenchWindow) {
            super(iWorkbenchWindow, string);
        }
    }
}

