/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    public static XMLMemento createReadRoot(Reader reader) throws WorkbenchException {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String string) throws WorkbenchException {
        Object object;
        String string2 = null;
        Exception exception = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            InputSource inputSource = new InputSource(reader);
            if (string != null) {
                inputSource.setSystemId(string);
            }
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node instanceof Element) {
                    return new XMLMemento(document, (Element)node);
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
            string2 = WorkbenchMessages.XMLMemento_parserConfigError;
        }
        catch (IOException iOException) {
            exception = iOException;
            string2 = WorkbenchMessages.XMLMemento_ioError;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
            string2 = WorkbenchMessages.XMLMemento_formatError;
        }
        object = null;
        if (exception != null) {
            object = exception.getMessage();
        }
        if (object == null || ((String)object).length() == 0) {
            object = string2 != null ? string2 : WorkbenchMessages.XMLMemento_noElement;
        }
        throw new WorkbenchException((String)object, exception);
    }

    public static XMLMemento createWriteRoot(String string) throws DOMException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException.getMessage());
        }
    }

    public XMLMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    @Override
    public IMemento createChild(String string) throws DOMException {
        Element element = this.factory.createElement(string);
        this.element.appendChild(element);
        return new XMLMemento(this.factory, element);
    }

    @Override
    public IMemento createChild(String string, String string2) throws DOMException {
        Element element = this.factory.createElement(string);
        element.setAttribute("IMemento.internal.id", string2 == null ? "" : string2);
        this.element.appendChild(element);
        return new XMLMemento(this.factory, element);
    }

    public IMemento copyChild(IMemento iMemento) throws DOMException {
        Element element = ((XMLMemento)iMemento).element;
        Element element2 = (Element)this.factory.importNode(element, true);
        this.element.appendChild(element2);
        return new XMLMemento(this.factory, element2);
    }

    @Override
    public IMemento getChild(String string) {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            Element element;
            Node node = nodeList.item(n2);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(string)) {
                return new XMLMemento(this.factory, element);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IMemento[] getChildren() {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return new IMemento[0];
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                arrayList.add(node);
            }
            ++n2;
        }
        n = arrayList.size();
        IMemento[] iMementoArray = new IMemento[n];
        int n3 = 0;
        while (n3 < n) {
            iMementoArray[n3] = new XMLMemento(this.factory, (Element)arrayList.get(n3));
            ++n3;
        }
        return iMementoArray;
    }

    @Override
    public IMemento[] getChildren(String string) {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        int n2 = 0;
        while (n2 < n) {
            Element element;
            Node node = nodeList.item(n2);
            if (node instanceof Element && (element = (Element)node).getNodeName().equals(string)) {
                arrayList.add(element);
            }
            ++n2;
        }
        n = arrayList.size();
        IMemento[] iMementoArray = new IMemento[n];
        int n3 = 0;
        while (n3 < n) {
            iMementoArray[n3] = new XMLMemento(this.factory, (Element)arrayList.get(n3));
            ++n3;
        }
        return iMementoArray;
    }

    @Override
    public Float getFloat(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        try {
            return new Float(string2);
        }
        catch (NumberFormatException numberFormatException) {
            WorkbenchPlugin.log("Memento problem - Invalid float for key: " + string + " value: " + string2, numberFormatException);
            return null;
        }
    }

    @Override
    public String getType() {
        return this.element.getNodeName();
    }

    @Override
    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    @Override
    public Integer getInteger(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        String string2 = attr.getValue();
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            WorkbenchPlugin.log("Memento problem - invalid integer for key: " + string + " value: " + string2, numberFormatException);
            return null;
        }
    }

    @Override
    public String getString(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public Boolean getBoolean(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return Boolean.valueOf(attr.getValue());
    }

    @Override
    public String getTextData() throws DOMException {
        Text text = this.getTextNode();
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    @Override
    public String[] getAttributeKeys() {
        NamedNodeMap namedNodeMap = this.element.getAttributes();
        int n = namedNodeMap.getLength();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Node node = namedNodeMap.item(n2);
            stringArray[n2] = node.getNodeName();
            ++n2;
        }
        return stringArray;
    }

    private Text getTextNode() {
        NodeList nodeList = this.element.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Text) {
                return (Text)node;
            }
            ++n2;
        }
        return null;
    }

    private void putElement(Element element, boolean bl) throws DOMException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            this.putString(attr.getName(), attr.getValue());
            ++n2;
        }
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        boolean bl2 = bl;
        int n3 = 0;
        while (n3 < n) {
            Node node = nodeList.item(n3);
            if (node instanceof Element) {
                XMLMemento xMLMemento = (XMLMemento)this.createChild(node.getNodeName());
                xMLMemento.putElement((Element)node, true);
            } else if (node instanceof Text && bl2) {
                this.putTextData(((Text)node).getData());
                bl2 = false;
            }
            ++n3;
        }
    }

    @Override
    public void putFloat(String string, float f) throws DOMException {
        this.element.setAttribute(string, String.valueOf(f));
    }

    @Override
    public void putInteger(String string, int n) throws DOMException {
        this.element.setAttribute(string, String.valueOf(n));
    }

    @Override
    public void putMemento(IMemento iMemento) throws DOMException {
        this.putElement(((XMLMemento)iMemento).element, false);
    }

    @Override
    public void putString(String string, String string2) throws DOMException {
        if (string2 == null) {
            return;
        }
        this.element.setAttribute(string, string2);
    }

    @Override
    public void putBoolean(String string, boolean bl) throws DOMException {
        this.element.setAttribute(string, bl ? "true" : "false");
    }

    @Override
    public void putTextData(String string) throws DOMException {
        Text text = this.getTextNode();
        if (text == null) {
            text = this.factory.createTextNode(string);
            this.element.insertBefore(text, this.element.getFirstChild());
        } else {
            text.setData(string);
        }
    }

    public void save(Writer writer) throws IOException {
        try (DOMWriter dOMWriter = new DOMWriter(writer);){
            dOMWriter.print(this.element);
        }
    }

    private static final class DOMWriter
    extends PrintWriter {
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public DOMWriter(Writer writer) {
            super(writer);
            this.println(XML_VERSION);
        }

        public void print(Element element) {
            boolean bl = element.hasChildNodes();
            this.startTag(element, bl);
            if (bl) {
                boolean bl2 = false;
                NodeList nodeList = element.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    Node node = nodeList.item(n);
                    if (node instanceof Element) {
                        if (!bl2) {
                            this.println();
                        }
                        this.print((Element)nodeList.item(n));
                        bl2 = false;
                    } else if (node instanceof Text) {
                        this.print(DOMWriter.getEscaped(node.getNodeValue()));
                        bl2 = true;
                    }
                    ++n;
                }
                if (!bl2) {
                    this.println();
                }
                this.endTag(element);
            }
        }

        private void startTag(Element element, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            stringBuffer.append(element.getTagName());
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                stringBuffer.append(" ");
                stringBuffer.append(attr.getName());
                stringBuffer.append("=\"");
                stringBuffer.append(DOMWriter.getEscaped(String.valueOf(attr.getValue())));
                stringBuffer.append("\"");
                ++n;
            }
            stringBuffer.append(bl ? ">" : "/>");
            this.print(stringBuffer.toString());
        }

        private void endTag(Element element) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("</");
            stringBuffer.append(element.getNodeName());
            stringBuffer.append(">");
            this.print(stringBuffer.toString());
        }

        private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
            String string = DOMWriter.getReplacement(c);
            if (string != null) {
                stringBuffer.append('&');
                stringBuffer.append(string);
                stringBuffer.append(';');
            } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ') {
                stringBuffer.append(c);
            }
        }

        private static String getEscaped(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n = 0;
            while (n < string.length()) {
                DOMWriter.appendEscapedChar(stringBuffer, string.charAt(n));
                ++n;
            }
            return stringBuffer.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

