/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class WorkbenchEncoding {
    private static Method CharsetIsSupportedMethod = null;

    static {
        try {
            Class<?> clazz = Class.forName("java.nio.charset.Charset");
            CharsetIsSupportedMethod = clazz.getMethod("isSupported", String.class);
        }
        catch (Exception exception) {}
    }

    public static String getWorkbenchDefaultEncoding() {
        return System.getProperty("file.encoding", "UTF-8");
    }

    public static List getDefinedEncodings() {
        List list = Collections.synchronizedList(new ArrayList());
        EncodingsRegistryReader encodingsRegistryReader = new EncodingsRegistryReader(list);
        encodingsRegistryReader.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", "encodings");
        String[] stringArray = new String[list.size()];
        ArrayList<String> arrayList = new ArrayList<String>();
        list.toArray(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            if (!WorkbenchEncoding.isSupported(stringArray[n])) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        for (String string : arrayList) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.WorkbenchEncoding_invalidCharset, (Object)string));
            list.remove(string);
        }
        return list;
    }

    private static boolean isSupported(String string) {
        if (CharsetIsSupportedMethod == null) {
            return true;
        }
        try {
            Object object = CharsetIsSupportedMethod.invoke(null, string);
            return Boolean.TRUE.equals(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    private static class EncodingsRegistryReader
    extends RegistryReader {
        private List encodings;

        public EncodingsRegistryReader(List list) {
            this.encodings = list;
        }

        @Override
        protected boolean readElement(IConfigurationElement iConfigurationElement) {
            String string = iConfigurationElement.getAttribute("name");
            if (string != null) {
                this.encodings.add(string);
            }
            return true;
        }
    }
}

