/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.handlers.CommandLegacyActionWrapper;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.services.IServiceLocator;

public class SubActionBars
extends EventManager
implements IActionBars {
    private static final Expression EXPRESSION = new Expression(){

        public final EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
            return EvaluationResult.TRUE;
        }

        public final void collectExpressionInfo(ExpressionInfo expressionInfo) {
            expressionInfo.addVariableNameAccess("LEGACY");
        }
    };
    public static final String P_ACTION_HANDLERS = "org.eclipse.ui.internal.actionHandlers";
    private Map actionHandlers;
    private boolean actionHandlersChanged;
    private Map activationsByActionIdByServiceLocator;
    private boolean active = false;
    private SubMenuManager menuMgr;
    private IActionBars parent;
    private IServiceLocator serviceLocator;
    private SubStatusLineManager statusLineMgr;
    private SubToolBarManager toolBarMgr;
    private Map actionIdByCommandId = new HashMap();

    public SubActionBars(IActionBars iActionBars) {
        this(iActionBars, null);
    }

    public SubActionBars(IActionBars iActionBars, IServiceLocator iServiceLocator) {
        if (iActionBars == null) {
            throw new NullPointerException("The parent cannot be null");
        }
        this.parent = iActionBars;
        this.serviceLocator = iServiceLocator;
    }

    public void activate() {
        this.activate(true);
    }

    public void activate(boolean bl) {
        this.setActive(true);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    protected final void basicSetActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public void clearGlobalActionHandlers() {
        if (this.actionHandlers != null) {
            this.actionHandlers.clear();
            this.actionHandlersChanged = true;
        }
        if (this.activationsByActionIdByServiceLocator != null) {
            for (Map.Entry entry : this.activationsByActionIdByServiceLocator.entrySet()) {
                IServiceLocator iServiceLocator = (IServiceLocator)entry.getKey();
                IHandlerService iHandlerService = (IHandlerService)iServiceLocator.getService(IHandlerService.class);
                Map map = (Map)entry.getValue();
                for (IHandlerActivation iHandlerActivation : map.values()) {
                    if (iHandlerService != null) {
                        iHandlerService.deactivateHandler(iHandlerActivation);
                    }
                    iHandlerActivation.getHandler().dispose();
                }
            }
            this.activationsByActionIdByServiceLocator.clear();
        }
    }

    protected SubMenuManager createSubMenuManager(IMenuManager iMenuManager) {
        return new SubMenuManager(iMenuManager);
    }

    protected SubToolBarManager createSubToolBarManager(IToolBarManager iToolBarManager) {
        return new SubToolBarManager(iToolBarManager);
    }

    public void deactivate() {
        this.deactivate(true);
    }

    public void deactivate(boolean bl) {
        this.setActive(false);
    }

    public void dispose() {
        this.clearGlobalActionHandlers();
        if (this.menuMgr != null) {
            this.menuMgr.dispose();
            this.menuMgr.disposeManager();
        }
        if (this.statusLineMgr != null) {
            this.statusLineMgr.disposeManager();
        }
        if (this.toolBarMgr != null) {
            this.toolBarMgr.disposeManager();
        }
        this.clearListeners();
    }

    protected void fireActionHandlersChanged() {
        if (this.actionHandlersChanged) {
            this.firePropertyChange(new PropertyChangeEvent((Object)this, P_ACTION_HANDLERS, null, null));
            this.actionHandlersChanged = false;
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    protected final boolean getActive() {
        return this.active;
    }

    @Override
    public IAction getGlobalActionHandler(String string) {
        if (this.actionHandlers == null) {
            return null;
        }
        return (IAction)this.actionHandlers.get(string);
    }

    public Map getGlobalActionHandlers() {
        return this.actionHandlers;
    }

    @Override
    public IMenuManager getMenuManager() {
        if (this.menuMgr == null) {
            this.menuMgr = this.createSubMenuManager(this.parent.getMenuManager());
            this.menuMgr.setVisible(this.active);
        }
        return this.menuMgr;
    }

    protected final IActionBars getParent() {
        return this.parent;
    }

    @Override
    public final IServiceLocator getServiceLocator() {
        if (this.serviceLocator != null) {
            return this.serviceLocator;
        }
        return this.parent.getServiceLocator();
    }

    @Override
    public IStatusLineManager getStatusLineManager() {
        if (this.statusLineMgr == null) {
            this.statusLineMgr = new SubStatusLineManager(this.parent.getStatusLineManager());
            this.statusLineMgr.setVisible(this.active);
        }
        return this.statusLineMgr;
    }

    @Override
    public IToolBarManager getToolBarManager() {
        if (this.toolBarMgr == null) {
            this.toolBarMgr = this.createSubToolBarManager(this.parent.getToolBarManager());
            this.toolBarMgr.setVisible(this.active);
        }
        return this.toolBarMgr;
    }

    protected final boolean isSubMenuManagerCreated() {
        return this.menuMgr != null;
    }

    protected final boolean isSubStatusLineManagerCreated() {
        return this.statusLineMgr != null;
    }

    protected final boolean isSubToolBarManagerCreated() {
        return this.toolBarMgr != null;
    }

    public void partChanged(IWorkbenchPart iWorkbenchPart) {
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    protected void setActive(boolean bl) {
        this.active = bl;
        if (this.menuMgr != null) {
            this.menuMgr.setVisible(bl);
        }
        if (this.statusLineMgr != null) {
            this.statusLineMgr.setVisible(bl);
        }
        if (this.toolBarMgr != null) {
            this.toolBarMgr.setVisible(bl);
        }
    }

    @Override
    public void setGlobalActionHandler(String string, IAction iAction) {
        if (string == null) {
            WorkbenchPlugin.log("Cannot set the global action handler for a null action id");
            return;
        }
        if (iAction instanceof CommandLegacyActionWrapper) {
            WorkbenchPlugin.log("Cannot feed a CommandLegacyActionWrapper back into the system");
            return;
        }
        if (iAction instanceof CommandAction) {
            return;
        }
        if (iAction != null) {
            if (this.actionHandlers == null) {
                this.actionHandlers = new HashMap(11);
            }
            this.actionHandlers.put(string, iAction);
            if (this.serviceLocator != null) {
                IHandlerActivation iHandlerActivation;
                Object object;
                String string2 = null;
                IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)this.serviceLocator.getService(IActionCommandMappingService.class);
                if (iActionCommandMappingService != null) {
                    string2 = iActionCommandMappingService.getCommandId(string);
                }
                if (string2 == null) {
                    string2 = iAction.getActionDefinitionId();
                }
                IHandlerService iHandlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
                HashMap<String, IHandlerActivation> hashMap = null;
                if (this.activationsByActionIdByServiceLocator == null) {
                    this.activationsByActionIdByServiceLocator = new WeakHashMap();
                    hashMap = new HashMap<String, IHandlerActivation>();
                    this.activationsByActionIdByServiceLocator.put(this.serviceLocator, hashMap);
                } else {
                    hashMap = (HashMap<String, IHandlerActivation>)this.activationsByActionIdByServiceLocator.get(this.serviceLocator);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        this.activationsByActionIdByServiceLocator.put(this.serviceLocator, hashMap);
                    } else if (hashMap.containsKey(string)) {
                        object = hashMap.remove(string);
                        if (object instanceof IHandlerActivation) {
                            iHandlerActivation = (IHandlerActivation)object;
                            this.actionIdByCommandId.remove(iHandlerActivation.getCommandId());
                            if (iHandlerService != null) {
                                iHandlerService.deactivateHandler(iHandlerActivation);
                            }
                            iHandlerActivation.getHandler().dispose();
                        }
                    } else if (string2 != null && this.actionIdByCommandId.containsKey(string2) && (object = hashMap.remove(this.actionIdByCommandId.remove(string2))) instanceof IHandlerActivation) {
                        iHandlerActivation = (IHandlerActivation)object;
                        if (iHandlerService != null) {
                            iHandlerService.deactivateHandler(iHandlerActivation);
                        }
                        iHandlerActivation.getHandler().dispose();
                    }
                }
                if (string2 != null) {
                    this.actionIdByCommandId.put(string2, string);
                    object = new ActionHandler(iAction);
                    iHandlerActivation = EXPRESSION;
                    if (this instanceof EditorActionBars) {
                        iHandlerActivation = ((EditorActionBars)this).getHandlerExpression();
                    }
                    if (iHandlerService != null) {
                        IHandlerActivation iHandlerActivation2 = iHandlerService.activateHandler(string2, (IHandler)object, (Expression)iHandlerActivation);
                        hashMap.put(string, iHandlerActivation2);
                    }
                }
            }
        } else {
            if (this.actionHandlers != null) {
                this.actionHandlers.remove(string);
            }
            if (this.serviceLocator != null) {
                Object v;
                Map map;
                IHandlerService iHandlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
                if (this.activationsByActionIdByServiceLocator != null && (map = (Map)this.activationsByActionIdByServiceLocator.get(this.serviceLocator)) != null && map.containsKey(string) && (v = map.remove(string)) instanceof IHandlerActivation) {
                    IHandlerActivation iHandlerActivation = (IHandlerActivation)v;
                    this.actionIdByCommandId.remove(iHandlerActivation.getCommandId());
                    iHandlerService.deactivateHandler(iHandlerActivation);
                    iHandlerActivation.getHandler().dispose();
                }
            }
        }
        this.actionHandlersChanged = true;
    }

    protected final void setServiceLocator(IServiceLocator iServiceLocator) {
        if (iServiceLocator == null) {
            throw new NullPointerException("The service locator cannot be null");
        }
        this.serviceLocator = iServiceLocator;
    }

    @Override
    public void updateActionBars() {
        this.parent.updateActionBars();
        this.fireActionHandlersChanged();
    }
}

