/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.osgi.framework.Bundle;

public final class SelectionEnabler {
    public static final int ANY_NUMBER = -2;
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = SelectionEnabler.class.getName().hashCode();
    private static Class iTextSelectionClass = null;
    private static final String JFACE_TEXT_PLUG_IN = "org.eclipse.jface.text";
    public static final int MULTIPLE = -5;
    public static final int NONE = -4;
    public static final int NONE_OR_ONE = -3;
    public static final int ONE_OR_MORE = -1;
    private static final String TEXT_SELECTION_CLASS = "org.eclipse.jface.text.ITextSelection";
    private static boolean textSelectionPossible = true;
    public static final int UNKNOWN = 0;
    private List classes = new ArrayList();
    private ActionExpression enablementExpression;
    private transient int hashCode = -1;
    private int mode = 0;

    private static Class getTextSelectionClass() {
        if (iTextSelectionClass != null) {
            return iTextSelectionClass;
        }
        if (!textSelectionPossible) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)JFACE_TEXT_PLUG_IN);
        if (bundle == null || bundle.getState() == 1) {
            textSelectionPossible = false;
            return null;
        }
        if (bundle.getState() == 2) {
            textSelectionPossible = true;
            return null;
        }
        try {
            Class clazz;
            iTextSelectionClass = clazz = bundle.loadClass(TEXT_SELECTION_CLASS);
            return iTextSelectionClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            textSelectionPossible = false;
            return null;
        }
    }

    public static boolean verifyNameMatch(String string, String string2) {
        return SimpleWildcardTester.testWildcardIgnoreCase(string2, string);
    }

    public SelectionEnabler(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            throw new IllegalArgumentException();
        }
        this.parseClasses(iConfigurationElement);
    }

    public final boolean equals(Object object) {
        if (object instanceof SelectionEnabler) {
            SelectionEnabler selectionEnabler = (SelectionEnabler)object;
            return Util.equals(this.classes, selectionEnabler.classes) && Util.equals(this.enablementExpression, selectionEnabler.enablementExpression) && Util.equals(this.mode, selectionEnabler.mode);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Util.hashCode(this.classes);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.enablementExpression);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.mode);
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    private boolean isEnabledFor(ISelection iSelection) {
        int n;
        ISelection iSelection2 = iSelection;
        int n2 = n = iSelection.isEmpty() ? 0 : 1;
        if (!this.verifySelectionCount(n)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(iSelection2);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        if (iSelection2 instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)iSelection2;
            return this.verifyElement(iAdaptable);
        }
        return false;
    }

    private boolean isEnabledFor(ISelection iSelection, int n) {
        if (!this.verifySelectionCount(n)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(iSelection);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.classes.size()) {
            SelectionClass selectionClass = (SelectionClass)this.classes.get(n2);
            if (this.verifyClass(iSelection, selectionClass.className)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isEnabledFor(IStructuredSelection iStructuredSelection) {
        int n = iStructuredSelection.size();
        if (!this.verifySelectionCount(n)) {
            return false;
        }
        if (this.enablementExpression != null) {
            return this.enablementExpression.isEnabledFor(iStructuredSelection);
        }
        if (this.classes.isEmpty()) {
            return true;
        }
        for (Object e : iStructuredSelection) {
            if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                if (this.verifyElement(iAdaptable)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isEnabledForSelection(ISelection iSelection) {
        if (this.mode == 0) {
            return false;
        }
        if (iSelection == null) {
            iSelection = StructuredSelection.EMPTY;
        }
        if (iSelection instanceof IStructuredSelection) {
            return this.isEnabledFor((IStructuredSelection)iSelection);
        }
        Class clazz = SelectionEnabler.getTextSelectionClass();
        if (clazz != null && clazz.isInstance(iSelection)) {
            try {
                Method method = clazz.getDeclaredMethod("getLength", new Class[0]);
                Object object = method.invoke((Object)iSelection, new Object[0]);
                if (object instanceof Integer) {
                    return this.isEnabledFor(iSelection, (Integer)object);
                }
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return this.isEnabledFor(iSelection);
    }

    private void parseClasses(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("enablesFor");
        if (string == null) {
            string = "*";
        }
        if (string.equals("*")) {
            this.mode = -2;
        } else if (string.equals("?")) {
            this.mode = -3;
        } else if (string.equals("!")) {
            this.mode = -4;
        } else if (string.equals("+")) {
            this.mode = -1;
        } else if (string.equals("multiple") || string.equals("2+")) {
            this.mode = -5;
        } else {
            try {
                this.mode = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.mode = 0;
            }
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("enablement");
        if (iConfigurationElementArray.length > 0) {
            this.enablementExpression = new ActionExpression(iConfigurationElementArray[0]);
            return;
        }
        iConfigurationElementArray = iConfigurationElement.getChildren("selection");
        if (iConfigurationElementArray.length > 0) {
            this.classes = new ArrayList();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
                String string2 = iConfigurationElement2.getAttribute("class");
                String string3 = iConfigurationElement2.getAttribute("name");
                SelectionClass selectionClass = new SelectionClass();
                selectionClass.className = string2;
                selectionClass.nameFilter = string3;
                this.classes.add(selectionClass);
                ++n;
            }
        }
    }

    private boolean verifyClass(Object object, String string) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object.getClass();
        boolean bl = false;
        while (clazz2 != null) {
            if (clazz2.getName().equals(string)) {
                bl = true;
                break;
            }
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].getName().equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) break;
            clazz2 = clazz2.getSuperclass();
        }
        return bl;
    }

    private boolean verifyElement(IAdaptable iAdaptable) {
        if (this.classes.isEmpty()) {
            return true;
        }
        int n = 0;
        while (n < this.classes.size()) {
            SelectionClass selectionClass = (SelectionClass)this.classes.get(n);
            if (this.verifyClass(iAdaptable, selectionClass.className)) {
                if (selectionClass.nameFilter == null) {
                    return true;
                }
                IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Util.getAdapter(iAdaptable, IWorkbenchAdapter.class);
                if (iWorkbenchAdapter != null && SelectionEnabler.verifyNameMatch(iWorkbenchAdapter.getLabel(iAdaptable), selectionClass.nameFilter)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean verifySelectionCount(int n) {
        if (n > 0 && this.mode == -4) {
            return false;
        }
        if (n == 0 && this.mode == -1) {
            return false;
        }
        if (n > 1 && this.mode == -3) {
            return false;
        }
        if (n < 2 && this.mode == -5) {
            return false;
        }
        return this.mode <= 0 || n == this.mode;
    }

    static class SelectionClass {
        public String className;
        public String nameFilter;
        public boolean recursive;

        SelectionClass() {
        }
    }
}

