/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class OpenAndLinkWithEditorHelper {
    private StructuredViewer viewer;
    private boolean isLinkingEnabled;
    private ISelection lastOpenSelection;
    private InternalListener listener;

    public OpenAndLinkWithEditorHelper(StructuredViewer structuredViewer) {
        Assert.isLegal((structuredViewer != null ? 1 : 0) != 0);
        this.viewer = structuredViewer;
        this.listener = new InternalListener();
        structuredViewer.addPostSelectionChangedListener((ISelectionChangedListener)this.listener);
        structuredViewer.addOpenListener((IOpenListener)this.listener);
        structuredViewer.addDoubleClickListener((IDoubleClickListener)this.listener);
    }

    public void setLinkWithEditor(boolean bl) {
        this.isLinkingEnabled = bl;
    }

    public void dispose() {
        this.viewer.removePostSelectionChangedListener((ISelectionChangedListener)this.listener);
        this.viewer.removeOpenListener((IOpenListener)this.listener);
        this.viewer.removeDoubleClickListener((IDoubleClickListener)this.listener);
        this.listener = null;
    }

    protected abstract void activate(ISelection var1);

    protected abstract void open(ISelection var1, boolean var2);

    protected abstract void linkToEditor(ISelection var1);

    private final class InternalListener
    implements IOpenListener,
    ISelectionChangedListener,
    IDoubleClickListener {
        private InternalListener() {
        }

        public final void open(OpenEvent openEvent) {
            OpenAndLinkWithEditorHelper.this.lastOpenSelection = openEvent.getSelection();
            OpenAndLinkWithEditorHelper.this.open(OpenAndLinkWithEditorHelper.this.lastOpenSelection, OpenStrategy.activateOnOpen());
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ISelection iSelection = selectionChangedEvent.getSelection();
            if (OpenAndLinkWithEditorHelper.this.isLinkingEnabled && !iSelection.equals(OpenAndLinkWithEditorHelper.this.lastOpenSelection) && OpenAndLinkWithEditorHelper.this.viewer.getControl().isFocusControl()) {
                OpenAndLinkWithEditorHelper.this.linkToEditor(iSelection);
            }
            OpenAndLinkWithEditorHelper.this.lastOpenSelection = null;
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            if (!OpenStrategy.activateOnOpen()) {
                OpenAndLinkWithEditorHelper.this.activate(doubleClickEvent.getSelection());
            }
        }
    }
}

