/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetElementAdapter;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class BasicWorkingSetElementAdapter
implements IWorkingSetElementAdapter,
IExecutableExtension {
    private Type[] preferredTypes = new Type[0];
    private ServiceTracker packageTracker;

    @Override
    public IAdaptable[] adaptElements(IWorkingSet iWorkingSet, IAdaptable[] iAdaptableArray) {
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IAdaptable iAdaptable = this.adapt(iAdaptableArray[n]);
            if (iAdaptable != null) {
                arrayList.add(iAdaptable);
            }
            ++n;
        }
        return arrayList.toArray(new IAdaptable[arrayList.size()]);
    }

    private IAdaptable adapt(IAdaptable iAdaptable) {
        int n = 0;
        while (n < this.preferredTypes.length) {
            IAdaptable iAdaptable2 = this.adapt(this.preferredTypes[n], iAdaptable);
            if (iAdaptable2 != null) {
                return iAdaptable2;
            }
            ++n;
        }
        return null;
    }

    private IAdaptable adapt(Type type, IAdaptable iAdaptable) {
        Class clazz;
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class[] classArray = iAdapterManager.computeClassOrder(iAdaptable.getClass());
        int n = 0;
        while (n < classArray.length) {
            clazz = classArray[n];
            if (clazz.getName().equals(type.className)) {
                return iAdaptable;
            }
            ++n;
        }
        if ((type.flags & 1) != 0) {
            String string;
            ExportedPackage[] exportedPackageArray;
            int n2;
            Object object = iAdapterManager.getAdapter((Object)iAdaptable, type.className);
            if (object instanceof IAdaptable) {
                return (IAdaptable)object;
            }
            clazz = this.getPackageAdmin();
            if (clazz != null && (n2 = type.className.lastIndexOf(46)) > 0 && (exportedPackageArray = clazz.getExportedPackages(string = type.className.substring(0, n2))) != null && exportedPackageArray.length == 1 && exportedPackageArray[0].getExportingBundle().getState() == 32) {
                try {
                    object = iAdaptable.getAdapter(exportedPackageArray[0].getExportingBundle().loadClass(type.className));
                    if (object instanceof IAdaptable) {
                        return (IAdaptable)object;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    WorkbenchPlugin.log(classNotFoundException);
                }
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.packageTracker != null) {
            this.packageTracker.close();
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        if (object instanceof String) {
            ArrayList<Type> arrayList = new ArrayList<Type>(0);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                Type type = new Type();
                this.parseOptions(string2, type);
                arrayList.add(type);
            }
            this.preferredTypes = arrayList.toArray(new Type[arrayList.size()]);
        }
    }

    private void parseOptions(String string, Type type) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (type.className == null) {
                type.className = string2;
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            while (stringTokenizer2.hasMoreTokens()) {
                if (stringTokenizer2.countTokens() != 2) continue;
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                if (!"adapt".equals(string3)) continue;
                type.flags = type.flags ^ ("true".equals(string4) ? 1 : 0);
            }
        }
    }

    private PackageAdmin getPackageAdmin() {
        if (this.packageTracker == null) {
            this.packageTracker = new ServiceTracker(WorkbenchPlugin.getDefault().getBundleContext(), PackageAdmin.class.getName(), null);
            this.packageTracker.open();
        }
        return (PackageAdmin)this.packageTracker.getService();
    }

    private class Type {
        private static final int NONE = 0;
        private static final int ADAPT = 1;
        String className;
        int flags;

        private Type() {
        }
    }
}

