/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.Map;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractSourceProvider
implements ISourceProvider {
    protected static boolean DEBUG = Policy.DEBUG_SOURCES;
    private ISourceProviderListener[] listeners = new ISourceProviderListener[7];
    private int listenerCount = 0;

    @Override
    public final void addSourceProviderListener(ISourceProviderListener iSourceProviderListener) {
        if (iSourceProviderListener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        if (this.listenerCount == this.listeners.length) {
            ISourceProviderListener[] iSourceProviderListenerArray = new ISourceProviderListener[this.listeners.length + 4];
            System.arraycopy(this.listeners, 0, iSourceProviderListenerArray, 0, this.listeners.length);
            this.listeners = iSourceProviderListenerArray;
        }
        this.listeners[this.listenerCount++] = iSourceProviderListener;
    }

    protected final void fireSourceChanged(int n, String string, Object object) {
        int n2 = 0;
        while (n2 < this.listenerCount) {
            ISourceProviderListener iSourceProviderListener = this.listeners[n2];
            iSourceProviderListener.sourceChanged(n, string, object);
            ++n2;
        }
    }

    protected final void fireSourceChanged(int n, Map map) {
        int n2 = 0;
        while (n2 < this.listenerCount) {
            ISourceProviderListener iSourceProviderListener = this.listeners[n2];
            iSourceProviderListener.sourceChanged(n, map);
            ++n2;
        }
    }

    protected final void logDebuggingInfo(String string) {
        if (DEBUG && string != null) {
            Tracing.printTrace((String)"SOURCES", (String)string);
        }
    }

    @Override
    public final void removeSourceProviderListener(ISourceProviderListener iSourceProviderListener) {
        if (iSourceProviderListener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.listenerCount) {
            if (this.listeners[n2] == iSourceProviderListener) {
                this.listeners[n2] = null;
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            n2 = n + 1;
            while (n2 < this.listenerCount) {
                this.listeners[n2 - 1] = this.listeners[n2];
                ++n2;
            }
            --this.listenerCount;
        }
    }

    public void initialize(IServiceLocator iServiceLocator) {
    }
}

