; To build this, spin up a VM using the 'Windows Installer development' AMI, then open this file using Inno Setup Compiler
; You need to compile the uninstaller before doing the installer
; After compiling both the uninstaller and installer, commit changes. The compiler should automatically place them in the correct places: Uninstaller goes into an Output subfolder of this directory, and that is then bundled into the WindowsInstaller.exe, which is placed into the dist directory.


[Setup]
PrivilegesRequired=admin
DisableDirPage=yes
; Disabled this so that we don't have to rebuild every time the major version number changes: DisableWelcomePage=no
AppName=MirrorSync
AppVersion=3.0
DefaultDirName="{sd}\Program Files\360Works\"
DefaultGroupName=360Works
Uninstallable=no
OutputDir=..\..\..\..\..\..\dist\
OutputBaseFilename=WindowsInstaller


[Run]
; Filename: "{src}\Installer data\installer.jar"; Parameters: {code:Params}; Flags: shellexec waituntilterminated hidewizard
Filename: "{src}\ReadMe.html"; Description: "View the README file"; Flags: postinstall shellexec skipifsilent unchecked

[Files]
Source: "{src}\Installer Data\installer.jar"; DestDir: "{app}\Internal\Uninstaller Data\"; Flags: external
Source: "{src}\Installer Data\MirrorSync.war"; DestDir: "{app}\Internal\Uninstaller Data\"; Flags: external
Source: "Output\UninstallMirrorSync.exe"; DestDir: "{app}"

[Icons]
Name: "{group}\360Works Admin"; Filename: "{app}\360Works Admin.jar"

[Code]
var
  Page: TInputOptionWizardPage;
  inputPage: TInputDirWizardPage;
  installResult: String;
  DataDir: String;
  InstallType: String;

function Params(DefaultString: String): String;
begin
  Result := InstallType;// + ' ' + DataDir;
end;


procedure CreateInputsPage;
begin
  Page := CreateInputOptionPage(wpWelcome,
  'MirrorSync Setup', 'Installation Type',
  'Please choose the installation method that suits your needs.',
  True, False);

// Add items
Page.Add('Standard Installation');
Page.Add('Install for Hosting Providers');

// Set initial values
Page.Values[0] := True;
Page.Values[1] := False;
end;

procedure CreateDirPage;
begin
  inputPage := CreateInputDirPage(100, 'Select Installation Directory', 'MirrorSync and its components will be unpacked and installed in this directory.', 'Data files will be stored in the following folder.'#13#10#13#10 +
  'To continue, click Next. If you would like to select a different folder, click Browse.', False, '360Works');
  //add item to page with empty caption
  inputPage.Add(' ');
  inputPage.Values[0] := ExpandConstant('{sd}\Program Files\360Works');
  DataDir := inputPage.Values[0];
end;

procedure InitializeWizard();
var
  BackgroundBitmapImage: TBitmapImage;
begin
  { Custom wizard pages }

  CreateInputsPage;
  //CreateDirPage;
  
  { Custom controls }

  BackgroundBitmapImage := TBitmapImage.Create(MainForm);
  BackgroundBitmapImage.Left := 50;
  BackgroundBitmapImage.Top := 90;
  BackgroundBitmapImage.AutoSize := True;
  BackgroundBitmapImage.Bitmap := WizardForm.WizardBitmapImage.Bitmap;
  BackgroundBitmapImage.Parent := MainForm;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
begin
  if CurPageID = 100 THEN
  begin
    InstallType := 'hostinstall';
    if Page.Values[0] = True then
    begin
      InstallType := 'install';
    end;
  end;
  if CurPageID = 101 THEN
  begin
    DataDir := inputPage.Values[0];
  end;
  Result := True;
end;
procedure ExitProcess(exitCode: Integer);
  external 'ExitProcess@kernel32.dll stdcall';

procedure CurPageChanged(CurPageID: Integer);
var
ErrorCode: Integer;

begin
  if CurPageID = 11 THEN
  begin
  //MsgBox(ExpandConstant('{src}\Installer data\installer.jar') + ' ' + Params(''), mbInformation, MB_OK); 
    if not ShellExec('', ExpandConstant('{src}\Installer data\installer.jar'),Params(''),ExpandConstant('{src}\Installer data\'),SW_SHOW,ewWaitUntilTerminated, ErrorCode) THEN
    begin
        MsgBox('shell execution failed. Verify that Java is installed and run setup again.' + IntToStr(ErrorCode), mbInformation, MB_OK);
    end;
    if not (ErrorCode = 0) THEN
    begin
        MsgBox('MirrorSync configuration process was unsuccessful or was cancelled. Setup will now exit.', mbInformation, MB_OK);
        ExitProcess(ErrorCode);
    end;
  //MsgBox(IntToStr(ErrorCode), mbInformation, MB_OK);
  end;
end;