/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.util;

import com.prosc.shared.StringUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class UrlUtil {
    public static boolean isSameHost(String address1, String address2, boolean dnsLookup) {
        String host1 = UrlUtil.convertToURL(address1, false).getHost();
        String host2 = UrlUtil.convertToURL(address2, false).getHost();
        if ("127.0.0.1".equalsIgnoreCase(host1)) {
            host1 = "localhost";
        }
        if ("127.0.0.1".equalsIgnoreCase(host2)) {
            host2 = "localhost";
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        if (dnsLookup) {
            try {
                InetAddress ipAddress1 = "localhost".equalsIgnoreCase(host1) ? InetAddress.getLocalHost() : InetAddress.getByName(host1);
                InetAddress ipAddress2 = "localhost".equalsIgnoreCase(host2) ? InetAddress.getLocalHost() : InetAddress.getByName(host2);
                return ipAddress1.equals(ipAddress2);
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
        return false;
    }

    @NotNull
    public static String stripToHostname(@NotNull String hostAddress) {
        return UrlUtil.convertToURL(hostAddress, false).getHost();
    }

    @NotNull
    public static URL convertToURL(String address, boolean ssl) {
        try {
            URL result;
            if (address.contains("://")) {
                result = new URL(address);
            } else {
                int port;
                String hostname;
                int portNumberIndex;
                String hostNoContext;
                String file = "";
                int slashMark = address.indexOf(47);
                if (slashMark != -1) {
                    file = address.substring(slashMark);
                }
                String string = hostNoContext = slashMark == -1 ? address : address.substring(0, slashMark);
                if (hostNoContext.startsWith("[")) {
                    int rightBracketMark = hostNoContext.indexOf("]");
                    if (rightBracketMark == -1) {
                        throw new MalformedURLException("Hostname contains a [, but no corresponding ]");
                    }
                    portNumberIndex = rightBracketMark + 1;
                    hostname = hostNoContext.substring(0, portNumberIndex);
                } else if (StringUtils.patternCount(hostNoContext, ":") > 1) {
                    hostname = hostNoContext;
                    portNumberIndex = -1;
                } else {
                    portNumberIndex = hostNoContext.indexOf(58);
                    hostname = portNumberIndex == -1 ? hostNoContext : hostNoContext.substring(0, portNumberIndex);
                }
                if (portNumberIndex != -1 && hostNoContext.length() > portNumberIndex + 1 && hostNoContext.charAt(portNumberIndex) == ':') {
                    port = Integer.parseInt(hostNoContext.substring(portNumberIndex + 1));
                    ssl = port % 1000 == 443;
                } else {
                    port = -1;
                }
                String protocol = ssl ? "https" : "http";
                result = new URL(protocol, hostname, port, file);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("This address contained an invalid value for the port number: " + address, e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot convert " + address + " to a valid URL", e);
        }
    }

    public static boolean isRawAddress(String hostnameOrAddress) {
        boolean isRawAddress = false;
        String[] segments = hostnameOrAddress.split("\\.");
        if (segments.length == 4) {
            isRawAddress = true;
            try {
                for (String segment : segments) {
                    int number = 0;
                    number = Integer.parseInt(segment);
                    if (number >= 0 && number <= 255) continue;
                    isRawAddress = false;
                    break;
                }
            }
            catch (NumberFormatException e) {
                isRawAddress = false;
            }
        }
        return isRawAddress;
    }
}

