/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import com.prosc.core.ExceptionCoreUtils;
import com.prosc.data.tuple.Pair;
import com.prosc.function.FunctionThrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ThreadUtil {
    private static final Logger log = Logger.getLogger(ThreadUtil.class.getName());

    public static Thread getThreadByName(@NotNull String name) {
        Thread returnThread = null;
        ThreadGroup topThreadGroup = null;
        for (ThreadGroup threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null; threadGroup = threadGroup.getParent()) {
            topThreadGroup = threadGroup;
        }
        if (topThreadGroup != null) {
            Thread[] threads = new Thread[topThreadGroup.activeCount()];
            topThreadGroup.enumerate(threads, true);
            for (Thread thread : threads) {
                if (!thread.getName().equals(name)) continue;
                returnThread = thread;
            }
        }
        return returnThread;
    }

    public static <T> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt) {
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1) throws E1 {
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws E1, E2 {
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3 {
        return ThreadUtil.getNoInterrupt(future, cancelOnInterrupt, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getNoInterrupt(Future<T> future, boolean cancelOnInterrupt, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6 {
        boolean isInterrupted = false;
        while (true) {
            try {
                T t = ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
                return t;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                isInterrupted = true;
                if (cancelOnInterrupt) {
                    future.cancel(true);
                    log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, sending cancellation request");
                    continue;
                }
                log.log(Level.WARNING, "Thread " + Thread.currentThread().getName() + " was interrupted, but will be ignored until task completes");
                continue;
            }
            break;
        }
        finally {
            if (isInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T getInterruptible(Future<T> future) throws InterruptedException {
        return ThreadUtil.getInterruptible(future, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1) throws E1, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable> T getInterruptible(Future<T> future, Class<E1> exceptionClass1, Class<E2> exceptionClass2) throws E1, E2, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws E1, E2, E3, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4) throws E1, E2, E3, E4, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5) throws E1, E2, E3, E4, E5, InterruptedException {
        return ThreadUtil.getInterruptible(future, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, RuntimeException.class, RuntimeException.class);
    }

    public static <T, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> T getInterruptible(Future<T> future, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws E1, E2, E3, E4, E5, E6, InterruptedException {
        if (future == null) {
            throw new IllegalArgumentException("Null future object was passed to ThreadUtil.getInterruptible()");
        }
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw ExceptionCoreUtils.rethrowTypeSafeException(e.getCause(), exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
        }
    }

    public static <T> T getOrNull(Future<T> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error while getting future result", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, I> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task) throws InterruptedException, ExecutionException {
        ArrayList<Future<Pair>> futures = new ArrayList<Future<Pair>>(inputs.size());
        ExecutorService worker = Executors.newFixedThreadPool(inputs.size());
        try {
            int n = 0;
            for (I i : inputs) {
                int index = n++;
                futures.add(worker.submit(() -> new Pair(index, task.apply(input))));
            }
            ArrayList result = new ArrayList(inputs.size());
            for (int n2 = 0; n2 < inputs.size(); ++n2) {
                result.add(null);
            }
            for (Future future : futures) {
                Pair pair = (Pair)future.get();
                result.set((Integer)pair.a, pair.b);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            worker.shutdown();
        }
    }

    public static <T, I, E1 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1) throws InterruptedException, E1 {
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2) throws InterruptedException, E1, E2 {
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, RuntimeException.class, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3) throws InterruptedException, E1, E2, E3 {
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4) throws InterruptedException, E1, E2, E3, E4 {
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, RuntimeException.class, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5) throws InterruptedException, E1, E2, E3, E4, E5 {
        return ThreadUtil.doTasks(inputs, task, exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, RuntimeException.class);
    }

    public static <T, I, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable, E4 extends Throwable, E5 extends Throwable, E6 extends Throwable> List<T> doTasks(@NotNull List<I> inputs, @NotNull FunctionThrowable<I, T> task, @NotNull Class<E1> exceptionClass1, @NotNull Class<E2> exceptionClass2, @NotNull Class<E3> exceptionClass3, @NotNull Class<E4> exceptionClass4, @NotNull Class<E5> exceptionClass5, @NotNull Class<E6> exceptionClass6) throws InterruptedException, E1, E2, E3, E4, E5, E6 {
        try {
            return ThreadUtil.doTasks(inputs, task);
        }
        catch (ExecutionException e) {
            throw ExceptionCoreUtils.rethrowTypeSafeException(e.getCause(), exceptionClass1, exceptionClass2, exceptionClass3, exceptionClass4, exceptionClass5, exceptionClass6);
        }
    }

    public static void sleepDebug(long milliseconds) {
        ThreadUtil.sleepDebug(milliseconds, false);
    }

    public static void sleepDebug(long milliseconds, boolean suppressWarning) {
        if (milliseconds > 0L) {
            try {
                if (!suppressWarning) {
                    log.warning("There is a debugging delay of " + milliseconds + " milliseconds; this should never happen in production code");
                }
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static void sleepProduction(int milliseconds) throws InterruptedException {
        if (milliseconds > 0) {
            log.config("Sleep called for " + milliseconds + " milliseconds");
            Thread.sleep(milliseconds);
        }
    }
}

