/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class MyThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(MyThreadFactory.class.getName());
    static final AtomicInteger poolNumber = new AtomicInteger(1);
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;
    private final boolean daemon;
    private Integer priority;

    public MyThreadFactory(String name) {
        this(name, false);
    }

    public MyThreadFactory(String name, boolean daemon) {
        this.daemon = daemon;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        String threadName = this.namePrefix + this.threadNumber.getAndIncrement();
        Thread t = new Thread(this.group, r, threadName, 0L){

            @Override
            public void interrupt() {
                Exception stacktrace;
                if (log.isLoggable(Level.FINE) && "cancel".equals((stacktrace = new Exception("stack trace only")).getStackTrace()[1].getMethodName())) {
                    log.log(Level.FINE, "Interrupting thread factory", stacktrace);
                }
                try {
                    MyThreadFactory.this.interrupt(this);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error while interrupting thread " + this, e);
                }
                super.interrupt();
            }
        };
        if (!this.daemon && t.isDaemon()) {
            t.setDaemon(false);
        } else if (this.daemon && !t.isDaemon()) {
            t.setDaemon(true);
        }
        if (this.priority == null) {
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
        } else {
            t.setPriority(this.priority);
        }
        return t;
    }

    protected void interrupt(Thread thread) {
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}

