/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.util.logging.Logger;

public class SimpleDebugTimer {
    private static final String CR = System.getProperty("line.separator");
    protected final long startTime;
    protected final boolean enabled;
    protected final StringBuffer progressMessage = new StringBuffer();
    protected String lastMessage = null;
    protected long lastMark;
    protected long currentTime;
    private boolean stopped = false;
    private static final Logger log = Logger.getLogger(SimpleDebugTimer.class.getName());

    public SimpleDebugTimer(String debugMessage) {
        this(debugMessage, true);
    }

    public SimpleDebugTimer(String debugMessage, boolean enabled) {
        this.startTime = System.currentTimeMillis();
        this.enabled = enabled;
        this.markTime("Starting timer: " + debugMessage);
    }

    public synchronized void markTime(String markMessage) {
        if (this.stopped) {
            throw new IllegalStateException("markTime was called after SimpleDebugTimer was stopped. Message: " + markMessage);
        }
        this.currentTime = System.currentTimeMillis();
        if (this.lastMessage != null) {
            long markTime = this.currentTime - this.lastMark;
            long totalTime = this.currentTime - this.startTime;
            this.progressMessage.append(markTime + "ms / " + totalTime + "ms: " + this.lastMessage + CR);
        }
        this.lastMessage = markMessage;
        this.lastMark = this.currentTime;
    }

    public synchronized void stop() {
        this.stop(null);
    }

    public synchronized void stop(String markMessage) {
        this.markTime(markMessage);
        if (this.enabled) {
            log.info("=== SimpleDebugTimer results ===" + StringUtils.CR + this.progressMessage.toString());
            log.info("Finished");
        }
        this.stopped = true;
    }

    public synchronized long timeElapsed() {
        return this.lastMark - this.startTime;
    }

    public static void main(String[] args) throws IOException {
        int counter;
        SimpleDebugTimer testTimer = new SimpleDebugTimer("Counting to 5,000,000");
        for (counter = 0; counter < 5000000; ++counter) {
        }
        testTimer.markTime("Counting to 100,000");
        for (counter = 0; counter < 100000; ++counter) {
        }
        testTimer.markTime("Counting  to 20,000,000");
        for (counter = 0; counter < 20000000; ++counter) {
        }
        testTimer.stop();
    }
}

