/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    private static final Logger log = Logger.getLogger(CollectionUtils.class.getName());

    public static <K, V> boolean putInMultiMapSet(Map<K, Set<V>> map, K key, V newValue) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            map.put(key, set);
        }
        return set.add(newValue);
    }

    public static <K, V> void putInMultiMap(Map<K, List<V>> map, K key, V newValue) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(newValue);
    }

    public static <E> int incrementCountingMap(Map<E, Integer> countingMap, E key, int incrementBy) {
        Integer oldCount = countingMap.get(key);
        if (oldCount == null) {
            countingMap.put(key, incrementBy);
            return incrementBy;
        }
        int newValue = oldCount + incrementBy;
        countingMap.put(key, newValue);
        return newValue;
    }

    public static void sort(final @Nullable Comparator comparator, List<?> ... inputs) {
        ListIterator[] iterators = new ListIterator[inputs.length];
        int inputSize = inputs[0].size();
        for (int i = 0; i < iterators.length; ++i) {
            if (inputs[i].size() != inputSize) {
                throw new IllegalArgumentException("All lists must contain the same number of elements, but the first list has " + inputSize + " elements and the current list does not: " + inputs[i]);
            }
            iterators[i] = inputs[i].listIterator();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(inputs[0].size());
        while (iterators[0].hasNext()) {
            Object[] row = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                row[i] = iterators[i].next();
            }
            rows.add(row);
        }
        Collections.sort(rows, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                if (comparator == null) {
                    return ((Comparable)o1[0]).compareTo(o2[0]);
                }
                return comparator.compare(o1[0], o2[0]);
            }
        });
        iterators = new ListIterator[inputs.length];
        for (int i = 0; i < iterators.length; ++i) {
            iterators[i] = inputs[i].listIterator();
        }
        for (Object[] row : rows) {
            for (int i = 0; i < iterators.length; ++i) {
                ListIterator listIterator = iterators[i];
                listIterator.next();
                listIterator.set(row[i]);
            }
        }
    }

    @NotNull
    public static <E> E last(List<E> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("List is empty");
        }
        return list.get(list.size() - 1);
    }

    public static <E> Optional<E> lastFiltered(@NotNull List<E> list, @NotNull Predicate<E> predicate) {
        for (int i = list.size() - 1; i >= 0; --i) {
            E v = list.get(i);
            if (!predicate.test(v)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    public static <E> E last(List<E> list, @Nullable E valueWhenEmpty) {
        if (list.isEmpty()) {
            return valueWhenEmpty;
        }
        if (list instanceof LinkedList) {
            return ((LinkedList)list).getLast();
        }
        return list.get(list.size() - 1);
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T ... elements) {
        Collections.addAll(collection, elements);
        return collection;
    }

    public static <E> ArrayList<E> newArrayList(E ... object) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, object);
        return result;
    }

    public static <In, Out> List<Out> transform(Collection<In> input, Function<In, Out> function) {
        ArrayList<Out> result = new ArrayList<Out>(input.size());
        for (In in : input) {
            result.add(function.apply(in));
        }
        return result;
    }

    public static <E> List<E> filter(Collection<E> input, Function<E, Boolean> filter) {
        ArrayList<E> result = new ArrayList<E>(input.size());
        for (E e : input) {
            if (!filter.apply(e).booleanValue()) continue;
            result.add(e);
        }
        return result;
    }

    public static <K, V> Map<K, V> indexBy(Collection<V> input, Function<V, K> function) {
        HashMap<K, V> result = new HashMap<K, V>(input.size());
        for (V v : input) {
            K key = function.apply(v);
            if (key == null) {
                log.log(Level.WARNING, "null index key for " + v + ", will not be added to index");
                continue;
            }
            V oldValue = result.put(key, v);
            if (oldValue == null) continue;
            if (!oldValue.equals(v)) {
                throw new IllegalStateException("Duplicate index key " + key + " in " + v);
            }
            log.log(Level.WARNING, "Duplicate index key " + key + " in " + v + ", but values are identical, so we will let it slide.");
        }
        return result;
    }

    @Nullable
    public static <E> E any(Collection<E> collection) {
        return collection.isEmpty() ? null : (E)collection.iterator().next();
    }

    public static <E> List<E> arrayListForIterator(Iterator<E> it) {
        ArrayList list = new ArrayList();
        it.forEachRemaining(list::add);
        return list;
    }

    public static <T> List<T> truncateList(List<T> collection, int maxItems) {
        if (collection.size() <= maxItems) {
            return collection;
        }
        return collection.subList(0, maxItems - 1);
    }

    public static <TR, TA extends TR, TB extends TR> Collection<TR> concat(Collection<TA> first, Collection<TB> second) {
        ArrayList<Object> result = new ArrayList<Object>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }
}

