/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.shared;

import com.prosc.shared.StringUtils;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CalendarUtils {
    private static final Logger log = Logger.getLogger(CalendarUtils.class.getName());
    private static final int[] orderedUnitsForYear = new int[]{2, 5, 11, 12, 13, 14};

    public static int yearsBetweenCalendars(Calendar firstDate, Calendar secondDate) {
        int result = secondDate.get(1) - firstDate.get(1);
        for (int n = 0; n < orderedUnitsForYear.length; ++n) {
            int difference = secondDate.get(orderedUnitsForYear[n]) - firstDate.get(orderedUnitsForYear[n]);
            if (difference > 0) {
                return result;
            }
            if (difference >= 0) continue;
            return result - 1;
        }
        return result;
    }

    public static void setTimeToFirstSecondOfDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static void setTimeToFirstSecondOfMonth(Calendar cal) {
        int month = cal.get(2);
        int year = cal.get(1);
        cal.clear();
        cal.set(year, month, 1);
    }

    public static void setTimeToLastSecondOfMonth(Calendar cal) {
        CalendarUtils.setTimeToFirstSecondOfMonth(cal);
        cal.add(2, 1);
        cal.add(13, -1);
    }

    public static void setTimeToLastSecondOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
    }

    public static double getDateRangeMonths(Date d1, Date d2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d2);
        CalendarUtils.setTimeToFirstSecondOfDay(cal);
        long d2millis = cal.getTimeInMillis();
        cal.setTime(d1);
        CalendarUtils.setTimeToFirstSecondOfDay(cal);
        double result = 0.0;
        while (cal.getTimeInMillis() <= d2millis) {
            cal.add(2, 1);
            result += 1.0;
        }
        cal.add(2, -1);
        result -= 1.0;
        int daysDifference = 0;
        while (cal.getTimeInMillis() < d2millis) {
            cal.add(6, 1);
            ++daysDifference;
        }
        return result += (double)daysDifference / 30.0;
    }

    public static TimeZone convertSecondOffsetIntoTimeZone(int secondsOffset, Date when) {
        String[] ids = new String[]{"GMT", "US/Eastern", "US/Central", "US/Mountain", "US/Pacific", "Asia/Tokyo", "Europe/Moscow", "Europe/Helsinki", "Europe/Paris", "Australia/Sydney", "Pacific/Guam"};
        TimeZone result = CalendarUtils.checkTimeZoneIds(ids, secondsOffset, when);
        if (result == null) {
            ids = TimeZone.getAvailableIDs();
            result = CalendarUtils.checkTimeZoneIds(ids, secondsOffset, when);
        }
        if (result == null) {
            throw new IllegalArgumentException("No matching time zone for " + secondsOffset + " seconds.");
        }
        return result;
    }

    private static TimeZone checkTimeZoneIds(String[] ids, int secondsOffset, Date when) {
        int millis = secondsOffset * 1000;
        for (String id : ids) {
            TimeZone zone = TimeZone.getTimeZone(id);
            if (!(when == null ? zone.getRawOffset() == millis : zone.getOffset(when.getTime()) == millis)) continue;
            return zone;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("Starting test");
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2003, 11, 21)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2004, 11, 21)) == 1);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2003, 11, 20), new GregorianCalendar(2004, 11, 19)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2005, 3, 1)) == 1);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2005, 2, 28)) == 0);
        CalendarUtils.assertion(CalendarUtils.yearsBetweenCalendars(new GregorianCalendar(2004, 2, 29), new GregorianCalendar(2003, 2, 28)) == -2);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 0, 10).getTime(), new GregorianCalendar(2005, 1, 28).getTime()) == 1.6);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 1).getTime()) == 1.0);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 2).getTime()) == 1.0333333333333334);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 2, 5).getTime()) == 1.1333333333333333);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 1).getTime()) == 0.0);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 2).getTime()) == 0.03333333333333333);
        CalendarUtils.assertion(CalendarUtils.getDateRangeMonths(new GregorianCalendar(2005, 1, 1).getTime(), new GregorianCalendar(2005, 1, 25).getTime()) == 0.8);
        System.out.println("Completed test");
    }

    private static void assertion(boolean condition) {
        if (!condition) {
            throw new RuntimeException("Assertion failed");
        }
    }

    public static void setTimeToFirstSundayOfWeek(Calendar cal) {
        long oldMillis = cal.getTimeInMillis();
        cal.set(7, 1);
        if (cal.getTimeInMillis() > oldMillis) {
            cal.add(4, -1);
        }
    }

    public static int currentYear() {
        return Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
    }

    public static Date addDays(Date dateFrom, int numberOfDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateFrom);
        cal.add(5, numberOfDays);
        return cal.getTime();
    }

    public static void setTimeToFirstSecondOfYear(Calendar cal) {
        cal.set(2, 0);
        CalendarUtils.setTimeToFirstSecondOfMonth(cal);
    }

    @NotNull
    public static Date add(Date from, int unit, int howMany) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(unit, howMany);
        return cal.getTime();
    }

    public static Date dateFromIndividualParts(Date date, Time time, TimeZone optionalTimeZone) {
        DateFormat df = DateFormat.getDateInstance(1);
        DateFormat tf = DateFormat.getTimeInstance(2);
        DateFormat dtf = DateFormat.getDateTimeInstance(1, 2);
        if (optionalTimeZone != null) {
            df.setTimeZone(optionalTimeZone);
            tf.setTimeZone(optionalTimeZone);
            dtf.setTimeZone(optionalTimeZone);
        }
        String dateString = df.format(date);
        String timeString = tf.format(time);
        try {
            return dtf.parse(dateString + " " + timeString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date date(int year, int monthOneBased, int dayOfMonth) {
        return CalendarUtils.date(year, monthOneBased, dayOfMonth, null);
    }

    public static Date date(int year, int monthOneBased, int dayOfMonth, @Nullable TimeZone timeZone) {
        Calendar instance = Calendar.getInstance();
        if (timeZone != null) {
            instance.setTimeZone(timeZone);
        }
        CalendarUtils.setTimeToFirstSecondOfDay(instance);
        instance.set(1, year);
        instance.set(2, monthOneBased - 1);
        instance.set(5, dayOfMonth);
        return instance.getTime();
    }

    public static Time time(int hours, int minutes, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return new Time(cal.getTime().getTime());
    }

    public static Date dateTime(int year, int monthOneBased, int dayOfMonth, int hour24, int minute, int second) {
        return CalendarUtils.dateTime(year, monthOneBased, dayOfMonth, hour24, minute, second, null);
    }

    public static Date dateTime(int year, int monthOneBased, int dayOfMonth, int hour24, int minute, int second, @Nullable TimeZone timeZone) {
        Calendar instance = Calendar.getInstance();
        if (timeZone != null) {
            instance.setTimeZone(timeZone);
        }
        CalendarUtils.setTimeToFirstSecondOfDay(instance);
        instance.set(1, year);
        instance.set(2, monthOneBased - 1);
        instance.set(5, dayOfMonth);
        instance.set(11, hour24);
        instance.set(12, minute);
        instance.set(13, second);
        return instance.getTime();
    }

    public static Date dateFrom8601(String date) throws ParseException {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").parse(date);
    }

    public static LocalDate parseLocalDateFlexible(@Nullable String source, DateTimeFormatter ... formatters) throws ParseException {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        if (formatters == null || formatters.length == 0) {
            formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ofPattern("M/d/yyyy"), DateTimeFormatter.ofPattern("M/d/yy"), DateTimeFormatter.ofPattern("M-d-yyyy")};
        }
        for (DateTimeFormatter eachFormatter : formatters) {
            try {
                return LocalDate.parse(source, eachFormatter);
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to parse " + source + " using " + eachFormatter, e);
            }
        }
        throw new ParseException("Could not parse " + source + " as localDate using " + Arrays.asList(formatters), 0);
    }

    public static LocalTime parseLocalTimeFlexible(String source, DateTimeFormatter ... formatters) throws ParseException {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        if (formatters == null || formatters.length == 0) {
            source = source.toUpperCase().replace(" ", "");
            formatters = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ofPattern("h:m:sa"), DateTimeFormatter.ofPattern("h:ma"), DateTimeFormatter.ofPattern("ha"), DateTimeFormatter.ofPattern("H:m:s"), DateTimeFormatter.ofPattern("H:m"), DateTimeFormatter.ofPattern("H")};
        }
        for (DateTimeFormatter eachFormatter : formatters) {
            try {
                return LocalTime.parse(source, eachFormatter);
            }
            catch (Exception e) {
                log.log(Level.FINER, "Unable to parse " + source + " using " + eachFormatter, e);
            }
        }
        throw new ParseException("Could not parse " + source + " as LocalTime using " + Arrays.asList(formatters), 0);
    }

    public static Date localDateTimeToDate(LocalDateTime dateTime, ZoneId zone) {
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return Date.from(dateTime.atZone(zone).toInstant());
    }

    public static TemporalAdjuster addWorkingDays(long workingDays) {
        return TemporalAdjusters.ofDateAdjuster(d -> CalendarUtils.addWorkingDays(d, workingDays));
    }

    public static TemporalAdjuster nearestMinuteInterval(int roundingSize) {
        return temporal -> {
            int minute = temporal.get(ChronoField.MINUTE_OF_HOUR);
            int nearestMinuteBlock = (int)Math.round((double)minute / (double)roundingSize) * roundingSize;
            int adjustBy = nearestMinuteBlock - minute;
            return temporal.with(ChronoField.SECOND_OF_MINUTE, 0L).with(ChronoField.MILLI_OF_SECOND, 0L).plus(adjustBy, ChronoUnit.MINUTES);
        };
    }

    public static String HHmm(LocalTime localTime) {
        return localTime == null ? null : localTime.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    private static LocalDate addWorkingDays(LocalDate startingDate, long workingDays) {
        if (workingDays == 0L) {
            return CalendarUtils.nextOrSameWorkingDay(startingDate);
        }
        LocalDate result = startingDate;
        int step = Long.signum(workingDays);
        for (long i = 0L; i < Math.abs(workingDays); ++i) {
            result = CalendarUtils.nextWorkingDay(result, step);
        }
        return result;
    }

    private static LocalDate nextOrSameWorkingDay(LocalDate date) {
        return CalendarUtils.isWeekEnd(date) ? CalendarUtils.nextWorkingDay(date, 1) : date;
    }

    private static LocalDate nextWorkingDay(LocalDate date, int step) {
        while (CalendarUtils.isWeekEnd(date = date.plusDays(step))) {
        }
        return date;
    }

    private static boolean isWeekEnd(LocalDate date) {
        DayOfWeek dow = date.getDayOfWeek();
        return dow == DayOfWeek.SATURDAY || dow == DayOfWeek.SUNDAY;
    }
}

