/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.servlet.installer;

import com.prosc.exception.UserCanceledException;
import com.prosc.servlet.admin.TomcatStoppedException;
import com.prosc.servlet.installer.InstallerAbortException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInstaller {
    public boolean canRemove() throws IOException {
        try {
            return this.isInstalled();
        }
        catch (TomcatStoppedException e) {
            return false;
        }
    }

    public abstract void overrideInstallLocation(@Nullable File var1) throws UserCanceledException, IOException, InstallerAbortException;

    public abstract void overrideApplicationName(@Nullable JFrame var1) throws UserCanceledException;

    public abstract boolean isInstalled() throws IOException, TomcatStoppedException;

    public abstract void runInstaller(@Nullable JFrame var1, @Nullable ActionEvent var2) throws IOException, UserCanceledException, InstallerAbortException, InterruptedException;

    public abstract void runUninstaller() throws IOException, InstallerAbortException, InterruptedException;

    public abstract String getInstallInstructions();

    public abstract String getSuccessMessage();

    public abstract String getUninstallMessage();

    public abstract String getVersionInfo() throws IOException;

    public void checkConfiguration() throws Exception {
    }

    public abstract String getProductTitle();

    public void installFinished() {
    }
}

