/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.license.client.InvalidLicenseException;
import com.prosc.mirror.model.Device;
import java.io.Serializable;
import java.util.List;

public class LicenseInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Device> devices;
    private final String maxDeviceMessage;
    private final String generalLicenseInfo;
    private final String licenseKey;
    private final String registeredToName;
    private final boolean demo;
    private final InvalidLicenseException exception;
    private final int deviceLimit;
    private final int configurationCountLimit;
    private long syncDataSize;
    private long auditLogSize;

    public LicenseInfo(List<Device> devices, String maxDeviceMessage, String generalLicenseInfo, String licenseKey, String registeredToName, boolean demo, int deviceLimit, int configurationCountLimit) {
        this.devices = devices;
        this.maxDeviceMessage = maxDeviceMessage;
        this.generalLicenseInfo = generalLicenseInfo;
        this.licenseKey = licenseKey;
        this.registeredToName = registeredToName;
        this.demo = demo;
        this.configurationCountLimit = configurationCountLimit;
        this.deviceLimit = deviceLimit;
        this.exception = null;
    }

    public LicenseInfo(List<Device> deviceList, InvalidLicenseException e) {
        String failureMessage;
        this.devices = deviceList;
        this.exception = e;
        this.configurationCountLimit = 0;
        this.deviceLimit = 0;
        this.maxDeviceMessage = failureMessage = e.getMessage();
        this.generalLicenseInfo = failureMessage;
        this.licenseKey = null;
        this.registeredToName = null;
        this.demo = false;
    }

    private LicenseInfo() {
        this.devices = null;
        this.maxDeviceMessage = null;
        this.generalLicenseInfo = null;
        this.licenseKey = null;
        this.registeredToName = null;
        this.demo = false;
        this.exception = null;
        this.deviceLimit = 0;
        this.configurationCountLimit = 0;
    }

    public List<Device> getDevices() {
        return this.devices;
    }

    public String getMaxDeviceMessage() {
        return this.maxDeviceMessage;
    }

    public String getGeneralLicenseInfo() {
        return this.generalLicenseInfo;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getRegisteredToName() {
        return this.registeredToName;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setSyncDataSize(long syncDataSize) {
        this.syncDataSize = syncDataSize;
    }

    public long getSyncDataSize() {
        return this.syncDataSize;
    }

    public void setAuditLogSize(long auditLogSize) {
        this.auditLogSize = auditLogSize;
    }

    public long getAuditLogSize() {
        return this.auditLogSize;
    }

    public InvalidLicenseException getException() {
        return this.exception;
    }

    public int getDeviceLimit() {
        return this.deviceLimit;
    }

    public int getConfigurationCountLimit() {
        return this.configurationCountLimit;
    }
}

