/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HostedDatabaseOrFolder
implements TreeNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    @JsonManagedReference
    private final List<HostedDatabaseOrFolder> children;
    private final boolean isFolder;
    private final long size;
    @JsonBackReference
    @Nullable
    private final HostedDatabaseOrFolder parent;

    public HostedDatabaseOrFolder(@NotNull String name, boolean folder, @Nullable HostedDatabaseOrFolder parent, List<HostedDatabaseOrFolder> children, Long size) {
        this.name = name;
        this.isFolder = folder;
        this.parent = parent;
        this.children = children;
        this.size = size == null ? 0L : size;
    }

    private HostedDatabaseOrFolder() {
        this.name = null;
        this.children = null;
        this.isFolder = false;
        this.size = 0L;
        this.parent = null;
    }

    public static HostedDatabaseOrFolder createRoot(String name) {
        return new HostedDatabaseOrFolder(name, true, null, new ArrayList<HostedDatabaseOrFolder>(), 0L);
    }

    public Enumeration<HostedDatabaseOrFolder> children() {
        return Collections.enumeration(this.children == null ? Collections.emptyList() : this.children);
    }

    public List<HostedDatabaseOrFolder> getChildren() {
        return this.children;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isFolder;
    }

    @Override
    public boolean isLeaf() {
        return !this.isFolder;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children == null ? null : (TreeNode)this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        HostedDatabaseOrFolder typesafeNode = (HostedDatabaseOrFolder)node;
        return this.children == null ? -1 : this.children.indexOf(typesafeNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public long getSize() {
        return this.size;
    }

    @NotNull
    public HostedDatabaseOrFolder getOrCreate(String relativePath) {
        assert (this.isFolder);
        if (relativePath.isEmpty()) {
            return this;
        }
        int index = relativePath.indexOf(47);
        if (index == 0) {
            return this.getOrCreate(relativePath.substring(1));
        }
        if (index == -1) {
            for (HostedDatabaseOrFolder eachChild : this.children) {
                if (!eachChild.getName().equals(relativePath)) continue;
                return eachChild;
            }
            HostedDatabaseOrFolder newChild = new HostedDatabaseOrFolder(relativePath, true, this, new ArrayList<HostedDatabaseOrFolder>(), 0L);
            this.children.add(newChild);
            return newChild;
        }
        return this.getOrCreate(relativePath.substring(0, index)).getOrCreate(relativePath.substring(index + 1));
    }

    public void addChild(String name, Long size) {
        assert (this.isFolder);
        this.children.add(new HostedDatabaseOrFolder(name, false, this, new ArrayList<HostedDatabaseOrFolder>(), size));
    }

    public String toString() {
        return "HostedDatabaseOrFolder{name='" + this.name + '\'' + ", isFolder=" + this.isFolder + '}';
    }

    public TreePath findRecursive(String dbName) {
        TreePath result = null;
        for (HostedDatabaseOrFolder eachChild : this.children) {
            if (eachChild.isFolder()) {
                result = eachChild.findRecursive(dbName);
            } else if (eachChild.getNameWithoutExtension().equals(dbName)) {
                result = eachChild.getTreePath();
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getNameWithoutExtension() {
        int index = this.name.lastIndexOf(46);
        return index == -1 ? this.name : this.name.substring(0, index);
    }

    public TreePath getTreePath() {
        return this.parent == null ? new TreePath(this) : this.parent.getTreePath().pathByAddingChild(this);
    }
}

