/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.prosc.core.FeedbackException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class ForeignKeyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fromColumn;
    private String toTable;

    public ForeignKeyInfo(@JsonProperty(value="fromColumn") @Nullable String fromColumn, @JsonProperty(value="toTable") @Nullable String toTable) {
        this.fromColumn = fromColumn;
        this.toTable = toTable;
    }

    @Nullable
    public String getFromColumn() {
        return this.fromColumn;
    }

    @Nullable
    public String getToTable() {
        return this.toTable;
    }

    public void setFromColumn(String fromColumn) {
        this.fromColumn = fromColumn;
    }

    public void setToTable(String toTable) {
        this.toTable = toTable;
    }

    public String toString() {
        return this.fromColumn + "->" + this.toTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKeyInfo that = (ForeignKeyInfo)o;
        if (this.fromColumn != null ? !this.fromColumn.equals(that.fromColumn) : that.fromColumn != null) {
            return false;
        }
        return !(this.toTable != null ? !this.toTable.equals(that.toTable) : that.toTable != null);
    }

    public int hashCode() {
        int result = this.fromColumn != null ? this.fromColumn.hashCode() : 0;
        result = 31 * result + (this.toTable != null ? this.toTable.hashCode() : 0);
        return result;
    }

    public void validate() throws FeedbackException {
        if (this.getFromColumn() == null) {
            throw new FeedbackException("Foreign key does not have a column specified; fix that before proceeding");
        }
        if (this.getToTable() == null) {
            throw new FeedbackException("Foreign key '" + this.getFromColumn() + "' does not have a destiantion table specified; fix that before prceeding");
        }
    }
}

