/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.core.FeedbackException;
import com.prosc.io.IOUtils;
import com.prosc.mirror.model.DatabaseType2;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.dbtypes.FileMakerServer;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class FMServerProperties
extends SqlProperties {
    private static final long serialVersionUID = 4L;
    private static final DatabaseType2 type2 = new FileMakerServer();
    private String dbServerInternalIp;
    private String dbServerExternalIp;
    private String webServerExternalIp;
    private boolean webServerSeparate = false;
    private boolean hub = true;
    private boolean jdbc = true;
    private boolean jdbcOnly = false;

    public FMServerProperties(IDatabaseType type, @Nullable UUID uniqueId) {
        super(uniqueId);
    }

    @Override
    public void setHostname(String hostname) {
        super.setHostname(hostname);
        if (!this.webServerSeparate) {
            this.setDbServerInternalIp(hostname);
        }
    }

    @Override
    public String getHostname() {
        return super.getHostname();
    }

    public String getDbServerInternalIp() {
        return this.dbServerInternalIp;
    }

    public void setDbServerInternalIp(String dbServerInternalIp) {
        this.dbServerInternalIp = dbServerInternalIp;
        this.getPcs().firePropertyChange("dbServerInternalIp", this.dbServerInternalIp, this.dbServerInternalIp);
    }

    public String getDbServerExternalIp() {
        return this.dbServerExternalIp;
    }

    public void setDbServerExternalIp(String dbServerExternalIp) {
        this.dbServerExternalIp = dbServerExternalIp;
        this.getPcs().firePropertyChange("dbServerExternalIp", this.dbServerExternalIp, this.dbServerExternalIp);
    }

    public String getWebServerExternalIp() {
        return this.webServerExternalIp;
    }

    public void setWebServerExternalIp(String webServerExternalIp) {
        this.webServerExternalIp = webServerExternalIp;
        this.getPcs().firePropertyChange("webServerExternalIp", this.webServerExternalIp, this.webServerExternalIp);
    }

    public boolean isWebServerSeparate() {
        return this.webServerSeparate;
    }

    public void setWebServerSeparate(boolean webServerSeparate) {
        this.webServerSeparate = webServerSeparate;
        this.getPcs().firePropertyChange("webServerSeparate", this.webServerSeparate, this.webServerSeparate);
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
        this.getPcs().firePropertyChange("jdbc", this.jdbc, this.jdbc);
    }

    public boolean isHub() {
        return this.hub;
    }

    public void setHub(boolean hub) {
        this.hub = hub;
        this.getPcs().firePropertyChange("hub", this.hub, this.hub);
    }

    public boolean isJdbcOnly() {
        return this.jdbcOnly;
    }

    public void setJdbcOnly(boolean jdbcOnly) {
        this.jdbcOnly = jdbcOnly;
        this.getPcs().firePropertyChange("jdbcOnly", this.jdbcOnly, this.jdbcOnly);
    }

    @Override
    public void validate() throws FeedbackException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FMServerProperties that = (FMServerProperties)o;
        if (this.jdbcOnly != that.jdbcOnly) {
            return false;
        }
        if (this.hub != that.hub) {
            return false;
        }
        if (this.jdbc != that.jdbc) {
            return false;
        }
        if (this.webServerSeparate != that.webServerSeparate) {
            return false;
        }
        if (this.dbServerExternalIp != null ? !this.dbServerExternalIp.equals(that.dbServerExternalIp) : that.dbServerExternalIp != null) {
            return false;
        }
        if (this.dbServerInternalIp != null ? !this.dbServerInternalIp.equals(that.dbServerInternalIp) : that.dbServerInternalIp != null) {
            return false;
        }
        return !(this.webServerExternalIp != null ? !this.webServerExternalIp.equals(that.webServerExternalIp) : that.webServerExternalIp != null);
    }

    @Override
    public IDatabaseType getType() {
        return type2;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dbServerInternalIp != null ? this.dbServerInternalIp.hashCode() : 0);
        result = 31 * result + (this.dbServerExternalIp != null ? this.dbServerExternalIp.hashCode() : 0);
        result = 31 * result + (this.webServerExternalIp != null ? this.webServerExternalIp.hashCode() : 0);
        result = 31 * result + (this.webServerSeparate ? 1 : 0);
        result = 31 * result + (this.hub ? 1 : 0);
        result = 31 * result + (this.jdbc ? 1 : 0);
        result = 31 * result + (this.jdbcOnly ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "FMServerProperties{dbServerInternalIp='" + this.dbServerInternalIp + '\'' + ", dbServerExternalIp='" + this.dbServerExternalIp + '\'' + ", webServerExternalIp='" + this.webServerExternalIp + '\'' + ", webServerSeparate=" + this.webServerSeparate + ", hub=" + this.hub + "} " + super.toString();
    }

    public String getFmOpenUrl(Integer serverVersion) {
        String urlPrefix = serverVersion < 12 ? "fmp7://" : "fmp://";
        return urlPrefix + this.getDbServerInternalIp() + "/" + IOUtils.urlEncoded(this.getDatabase(), new Object[0]);
    }
}

