/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.model;

import com.prosc.core.AppSettings;
import com.prosc.io.IOUtils;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.MirrorConfigServer;
import com.prosc.shared.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientExtensionLoader {
    private static final Logger log = Logger.getLogger(ClientExtensionLoader.class.getName());
    private static URL serverUrl;
    private static Collection<IDatabaseType> databaseTypes;

    private ClientExtensionLoader() {
    }

    public static void setServerUrl(URL serverUrl) throws IllegalStateException {
        if (serverUrl == null) {
            return;
        }
        if (ClientExtensionLoader.serverUrl != null) {
            throw new IllegalStateException("setServerUrl was called more than once.");
        }
        ClientExtensionLoader.serverUrl = serverUrl;
        try {
            URL networkJarListUrl = new URL(serverUrl, "listExtensions");
            String[] networkJarUrlStrings = IOUtils.getUrlContents(networkJarListUrl.toExternalForm()).split("\n");
            System.setProperty("java.rmi.server.codebase", StringUtils.join(System.getProperty("path.separator"), networkJarUrlStrings));
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Can't load database types from server; will only use built-in types.", e);
        }
    }

    public static IDatabaseType forName(String name, @Nullable MirrorConfigServer configServer) {
        if ("FileMaker_Go".equals(name)) {
            name = "FileMaker Pro/Go";
        } else if ("FileMaker_Client".equals(name)) {
            name = "FileMakerClient";
        } else if ("FileMaker_Server".equals(name)) {
            name = "FileMaker Server";
        } else if ("FileMaker_Server_Advanced".equals(name)) {
            name = "FileMakerServerAdvanced";
        } else if ("MSSQL".equals(name)) {
            name = "MSSQLServer";
        }
        if (databaseTypes == null) {
            if (configServer == null) {
                databaseTypes = ClientExtensionLoader.readDatabaseTypesFromLocalClassPath();
            } else {
                try {
                    databaseTypes = configServer.getDatabaseTypes();
                }
                catch (RemoteException e) {
                    log.log(Level.WARNING, "Could not get list of database types from server; will read from local classpath");
                    databaseTypes = ClientExtensionLoader.readDatabaseTypesFromLocalClassPath();
                }
            }
        }
        for (IDatabaseType candidate : databaseTypes) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("No database type is loaded for name " + name);
    }

    public static List<IDatabaseType> readDatabaseTypesFromLocalClassPath() {
        ServiceLoader<IDatabaseType> services = ServiceLoader.load(IDatabaseType.class);
        LinkedHashSet<IDatabaseType> dbTypes = new LinkedHashSet<IDatabaseType>(20);
        try {
            for (IDatabaseType service : services) {
                try {
                    dbTypes.add(service);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Unable to read service", e);
                }
            }
            String[] extraDatabaseTypesArray = AppSettings.getSharedInstance().getProperty("extraDatabaseTypes", "").split(",");
            HashSet<String> extraDatabaseTypes = new HashSet<String>(Arrays.asList(extraDatabaseTypesArray));
            for (String eachExtraTypeName : extraDatabaseTypes) {
                if (StringUtils.isEmpty(eachExtraTypeName = eachExtraTypeName.trim())) continue;
                try {
                    IDatabaseType extraType = (IDatabaseType)Class.forName(eachExtraTypeName).newInstance();
                    dbTypes.add(extraType);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "Could not instantiate extra database type " + eachExtraTypeName, t);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return new ArrayList<IDatabaseType>(dbTypes);
    }
}

