/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.config.client;

import com.prosc.data.tuple.Pair;
import com.prosc.mirror.config.client.ConfigClientNodes;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.TableInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Table {
    @NotNull
    private final ConfigClientNodes configClientNodes;
    @Nullable
    private TableInfo tableInfo = null;

    public Table(@NotNull ConfigClientNodes configClientNodes) {
        this.configClientNodes = configClientNodes;
    }

    @Nullable
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    @Nullable
    public TableConfig getTableConfig() {
        if (this.tableInfo == null) {
            return null;
        }
        Pair<TableConfig, TableConfig> pair = this.configClientNodes.getModel().getTableMap().get(this.tableInfo.getTableName());
        if (pair == null) {
            return null;
        }
        return this.configClientNodes.isHub() ? (TableConfig)pair.a : (TableConfig)pair.b;
    }

    public static Map<String, Table> map(List<TableConfig> tables, ConfigClientNodes configClientNodes) {
        HashMap<String, Table> result = new HashMap<String, Table>(tables.size());
        for (TableConfig table : tables) {
            result.put(table.getTableName().toLowerCase(), new Table(configClientNodes));
        }
        return result;
    }

    public void setTableInfo(@Nullable TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }
}

