/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.mirror.config.client;

import com.prosc.data.tuple.Pair;
import com.prosc.mirror.config.NoSuchTableException;
import com.prosc.mirror.config.client.Table;
import com.prosc.mirror.config.client.WizardModel;
import com.prosc.mirror.model.DatabaseProperties;
import com.prosc.mirror.model.FMServerPropertiesV6;
import com.prosc.mirror.model.FileMakerPropertiesV6;
import com.prosc.mirror.model.IDatabaseType;
import com.prosc.mirror.model.MirrorSyncException;
import com.prosc.mirror.model.SqlProperties;
import com.prosc.mirror.model.TableConfig;
import com.prosc.mirror.model.TableInfo;
import com.prosc.sync.NoSuchDatabaseException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigClientNodes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ConfigClientNodes.class.getName());
    private final boolean hub;
    private DatabaseProperties databaseProperties;
    private Collection<String> tableNames;
    private final WizardModel model;

    ConfigClientNodes(WizardModel model, boolean hub, @Nullable DatabaseProperties databaseProperties) {
        this.model = model;
        this.databaseProperties = databaseProperties;
        this.hub = hub;
    }

    public ConfigClientNodes(WizardModel model, boolean hub) {
        this(model, hub, null);
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    public void setDatabaseProperties(DatabaseProperties databaseProperties) {
        if (databaseProperties != this.databaseProperties) {
            this.databaseProperties = databaseProperties;
            this.tables().clear();
            for (Table eachTable : this.tables().values()) {
                eachTable.setTableInfo(null);
            }
            this.tableNames = null;
        }
    }

    private Map<String, Table> tables() {
        return this.hub ? this.model.getSourceTables() : this.model.getDestinationTables();
    }

    public void storeTableInfo(TableInfo tableInfo) {
        this.tableNamed(tableInfo.getTableName()).setTableInfo(tableInfo);
    }

    @NotNull
    private Table tableNamed(String tableName) {
        tableName = tableName.toLowerCase();
        Table result = this.tables().get(tableName);
        if (result == null) {
            result = new Table(this);
            this.tables().put(tableName, result);
        }
        return result;
    }

    @NotNull
    public Optional<TableConfig> getTableConfigWithName(String table, boolean onlyIfTableInfoExists) {
        Table tableObj = this.tableNamed(table);
        TableConfig result = tableObj.getTableConfig();
        if (result == null) {
            if (this.hub) {
                Pair<TableConfig, TableConfig> pair = this.getModel().getTableMap().get(table);
                result = pair == null ? null : (TableConfig)pair.a;
            } else {
                for (Pair<TableConfig, TableConfig> pair : this.getModel().getTableMap().values()) {
                    if (pair.b == null || !table.equals(((TableConfig)pair.b).getTableName())) continue;
                    result = (TableConfig)pair.b;
                    break;
                }
            }
        }
        if (result == null && !onlyIfTableInfoExists) {
            result = this.createTableConfigWithName(table);
        }
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    WizardModel getModel() {
        return this.model;
    }

    public TableConfig createTableConfigWithName(String table) {
        Table tableObj = this.tableNamed(table);
        if (tableObj.getTableConfig() == null) {
            try {
                return new TableConfig(this.getTableInfo(table));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Cannot create a new table named '" + table + "'; it already exists in the configuration");
    }

    @NotNull
    public Collection<String> getTableNames(boolean refresh) throws MirrorSyncException, NoSuchDatabaseException {
        try {
            if (this.tableNames == null || refresh) {
                this.tableNames = this.model.getConfigServer().getTableNames(this.databaseProperties);
            }
            return this.tableNames;
        }
        catch (RemoteException e) {
            throw new MirrorSyncException(e);
        }
    }

    @NotNull
    public TableInfo getTableInfo(String name) throws RemoteException, MirrorSyncException, NoSuchTableException {
        Map<String, TableInfo> tableInfos = this.getTableInfos(Collections.singletonList(name));
        if (tableInfos.containsKey(name)) {
            return tableInfos.get(name);
        }
        String hostname = this.databaseProperties instanceof SqlProperties ? ((SqlProperties)this.databaseProperties).getHostname() : "<unknown>";
        throw new NoSuchTableException("No table could be found on server '" + hostname + "' for table named '" + name + "'", name);
    }

    public Map<String, TableInfo> getTableInfos(@NotNull Collection<String> inputNames) throws MirrorSyncException, RemoteException, NoSuchTableException {
        String name;
        TableInfo info;
        ArrayList<String> names = new ArrayList<String>(inputNames);
        names.removeIf("<Create this table>"::equals);
        if (names.size() == 0) {
            log.config("inputNames.size is " + inputNames.size() + "; names.size is 0 after filtering out " + "<Create this table>");
            return Collections.emptyMap();
        }
        HashMap<String, TableInfo> result = new HashMap<String, TableInfo>(names.size());
        Iterator iterator = names.iterator();
        while (iterator.hasNext() && (info = this.tableNamed(name = (String)iterator.next()).getTableInfo()) != null) {
            result.put(name, info);
        }
        if (result.size() == names.size()) {
            log.config("In-memory entries were found for all " + names.size() + " requested tables, will not request from " + (this.hub ? "hub" : "spoke") + " database: " + names);
        } else {
            block12: {
                AbstractCollection tablesToQuery;
                result.clear();
                if (this.isHub()) {
                    tablesToQuery = names;
                } else {
                    tablesToQuery = new LinkedHashSet<String>(names);
                    ArrayList<String> virtualTables = new ArrayList<String>();
                    this.model.getTableMap().values().stream().map(pair -> (TableConfig)pair.b).filter(Objects::nonNull).filter(spokeTable -> names.contains(spokeTable.getTableName())).forEach(spokeTable -> {
                        if (spokeTable.isVirtual()) {
                            virtualTables.add(spokeTable.getTableName());
                            tablesToQuery.remove(spokeTable.getTableName());
                        }
                    });
                    if (!virtualTables.isEmpty()) {
                        Map<String, TableInfo> sourceTableInfos = this.model.getSource().getTableInfos(virtualTables);
                        List<TableInfo> duplicatedTableInfos = this.model.getConfigServer().duplicateTableInfos(this.databaseProperties, new ArrayList<TableInfo>(sourceTableInfos.values()));
                        duplicatedTableInfos.forEach(tableInfo -> result.put(tableInfo.getTableName(), (TableInfo)tableInfo));
                    }
                }
                try {
                    this.model.getConfigServer().getTableDetailInfos(this.databaseProperties, new ArrayList<String>(tablesToQuery)).forEach(tableInfo -> result.put(tableInfo.getTableName(), (TableInfo)tableInfo));
                }
                catch (NoSuchTableException e) {
                    if (!this.hub && this.databaseProperties instanceof FileMakerPropertiesV6 && this.model.getSource().getDatabaseProperties() instanceof FMServerPropertiesV6) {
                        FMServerPropertiesV6 serverProperties = ((FileMakerPropertiesV6)this.databaseProperties).getServerProperties();
                        FMServerPropertiesV6 hubProperties = (FMServerPropertiesV6)this.model.getSource().getDatabaseProperties();
                        if (serverProperties.getDatabase().equals(hubProperties.getDatabase())) {
                            result.clear();
                            result.putAll(this.model.getSource().getTableInfos(names));
                        }
                    }
                    if (result.size() == names.size()) break block12;
                    throw e;
                }
            }
            for (TableInfo eachInfo : result.values()) {
                String name2 = eachInfo.getTableName();
                Table tableObj = this.tableNamed(name2);
                tableObj.setTableInfo(eachInfo);
                TableConfig tableConfig = tableObj.getTableConfig();
                if (tableConfig == null) continue;
                tableConfig.refreshFrom(eachInfo);
            }
        }
        return result;
    }

    public String toString() {
        return "ConfigClientNodes{hub=" + this.hub + ", databaseProperties=" + this.databaseProperties + '}';
    }

    public void setSelectedType(IDatabaseType selectedType) {
        if (this.getDatabaseProperties() == null || !this.getDatabaseProperties().getType().equals(selectedType)) {
            DatabaseProperties newProperties = selectedType.createDatabaseProperties();
            if (this.hub && newProperties instanceof SqlProperties) {
                SqlProperties sqlProperties = (SqlProperties)newProperties;
                sqlProperties.setHostname(this.model.getSyncServerInternalAddress());
            }
            this.setDatabaseProperties(newProperties);
        }
    }

    public boolean isHub() {
        return this.hub;
    }
}

