/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.macinstaller;

import com.prosc.deployment.DeploymentInfo;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessUtils;
import com.prosc.servlet.installer.AbstractInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BuildInstaller {
    private static final Logger log = Logger.getLogger(BuildInstaller.class.getName());
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("com.prosc.servlet.installer.strings");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        File[] distributionFiles;
        DeploymentInfo info;
        AbstractInstaller installer;
        Manifest manifest;
        File warFile;
        File installerJar;
        block38: {
            System.err.println("Running BuildInstaller with params: " + Arrays.asList(args));
            String artifactFolder = args[0];
            installerJar = new File(artifactFolder, "Installer data/installer.jar");
            if (!installerJar.exists()) {
                installerJar = new File(artifactFolder, "installer.jar");
            }
            if (args.length < 2 || args[1] == null || String.valueOf(args[1]).length() == 0) {
                File[] warFiles = installerJar.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".war");
                    }
                });
                if (warFiles == null) {
                    throw new Exception("Received an error while attempting to get a list of files in the same directory as " + installerJar.getAbsolutePath());
                }
                if (warFiles.length == 1) {
                    warFile = warFiles[0];
                    break block38;
                } else {
                    if (warFiles.length == 0) {
                        throw new Exception("There are no .war files in the directory with " + installerJar.getAbsolutePath());
                    }
                    throw new Exception("There are multiple .war files in the same directory as " + installerJar.getAbsolutePath() + ". Make sure there is only one, or specify the name of the .war file as the second parameter.");
                }
            }
            String warFileName = args[1];
            warFile = new File(artifactFolder, "Installer data/" + warFileName);
        }
        log.info("Installer jar is at " + installerJar.getAbsolutePath());
        log.info("warFile is at " + warFile.getAbsolutePath());
        long totalSize = installerJar.length() + warFile.length();
        URLClassLoader loader = new URLClassLoader(new URL[]{installerJar.toURI().toURL()});
        try (InputStream manifestStream = new URL("jar:file:" + installerJar.getAbsolutePath() + "!/META-INF/MANIFEST.MF").openStream();){
            manifest = new Manifest(manifestStream);
        }
        String installerClassName = manifest.getMainAttributes().getValue("Main-Class");
        Class<?> installerClass = loader.loadClass(installerClassName);
        try {
            installer = (AbstractInstaller)installerClass.getConstructor(File.class).newInstance(warFile);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.WARNING, "Could not instantiate installer to query it; trying no-arg constructor version", e);
            installer = (AbstractInstaller)installerClass.newInstance();
        }
        try (InputStream stream = new URL("jar:file:" + warFile.getAbsolutePath() + "!/WEB-INF/classes/deployment.properties").openStream();){
            info = new DeploymentInfo(stream);
        }
        String fullyQualifiedName = info.getFullyQualifiedName();
        if (fullyQualifiedName == null) {
            throw new Exception("You must set the fullyQualifiedName in deployment.properties");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("product_install/resources/welcome.html"), "utf-8");){
            IOUtils.writeReaderToWriter(new StringReader(installer.getInstallInstructions()), writer);
        }
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream("product_uninstall/resources/welcome.html"), "utf-8");
        try {
            String msg = MessageFormat.format(resourceBundle.getString("installer.uninstallWarning"), installer.getProductTitle());
            IOUtils.writeReaderToWriter(new StringReader("<html><body><p>" + msg + "</p></body></html>"), writer);
        }
        finally {
            writer.close();
        }
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream("product_install/resources/conclusion.html"), "utf-8");
        try {
            IOUtils.writeReaderToWriter(new StringReader(installer.getSuccessMessage()), writer);
        }
        finally {
            writer.close();
        }
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream("product_uninstall/resources/conclusion.html"), "utf-8");
        try {
            IOUtils.writeReaderToWriter(new StringReader(installer.getUninstallMessage()), writer);
        }
        finally {
            writer.close();
        }
        File backgroundImage = new File("product_install/resources/background.png");
        backgroundImage.delete();
        if (info.getInstallerImageURL() != null) {
            log.info("Downloading product install image from " + info.getInstallerImageURL());
            FileOutputStream out = new FileOutputStream(backgroundImage);
            stream = info.getInstallerImageURL().openStream();
            try {
                IOUtils.writeInputToOutput(stream, (OutputStream)out, 8192);
            }
            finally {
                out.close();
                stream.close();
            }
        } else {
            log.info("There is no product install image; will use default background instead");
        }
        installer.getVersionInfo();
        File[] fileArray = distributionFiles = new File[]{new File("product_install/distribution.xml"), new File("product_uninstall/distribution.xml")};
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                log.info("Run build_installer.sh to create installer packages");
                String[] cmds = new String[]{"/bin/sh", "build_installer.sh", fullyQualifiedName};
                ProcessUtils.doShellCommand(cmds, null, null);
                return;
            }
            File distFile = fileArray[n2];
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(distFile);
            Element titleElement = (Element)doc.getElementsByTagName("title").item(0);
            titleElement.setTextContent(installer.getProductTitle());
            NodeList pkgRrefs = doc.getElementsByTagName("pkg-ref");
            for (int n3 = 0; n3 < pkgRrefs.getLength(); ++n3) {
                Element pkg = (Element)pkgRrefs.item(n3);
                if ("#install.pkg".equals(pkg.getTextContent())) {
                    pkg.setAttribute("installKBytes", String.valueOf(totalSize / 1024L));
                    pkg.setAttribute("id", fullyQualifiedName + ".install.pkg");
                    continue;
                }
                if ("#hostinstall.pkg".equals(pkg.getTextContent())) {
                    pkg.setAttribute("installKBytes", String.valueOf(totalSize / 1024L));
                    pkg.setAttribute("id", fullyQualifiedName + ".hosting.pkg");
                    continue;
                }
                if ("#uninstall.pkg".equals(pkg.getTextContent())) {
                    pkg.setAttribute("installKBytes", "0");
                    pkg.setAttribute("id", fullyQualifiedName + ".uninstall.pkg");
                    titleElement.setTextContent(installer.getProductTitle() + " uninstaller");
                    continue;
                }
                if (!"#hostuninstall.pkg".equals(pkg.getTextContent())) continue;
                pkg.setAttribute("installKBytes", "0");
                pkg.setAttribute("id", fullyQualifiedName + ".hostuninstall.pkg");
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(distFile));
            ++n2;
        }
    }
}

