/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private static final Logger log = Logger.getLogger(ZipCreator.class.getName());
    private Integer level;
    private long maximumZipSize = Long.MAX_VALUE;
    private long bytesWritten = 0L;
    private boolean includeFolders = true;
    private FileFilter filter;

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setMaximumZipSize(long maximumZipSize) {
        this.maximumZipSize = maximumZipSize;
    }

    public void createZip(File source, File destination, boolean includeFolders) throws IOException {
        this.includeFolders = includeFolders;
        this.createZip(source, destination);
    }

    public void createZip(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getPath());
        }
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException("Could not create directory " + destination.getParentFile());
        }
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(destination));){
            this.createZip(source, zipStream);
        }
    }

    public void createZip(File source, ZipOutputStream destination) throws IOException {
        if (this.level != null) {
            destination.setLevel(this.level);
        }
        byte[] buffer = new byte[16384];
        this.bytesWritten = 0L;
        this._zipRecursive(destination, source.getParentFile(), source, buffer);
    }

    private void _zipRecursive(ZipOutputStream out, File rootFile, File fileOrDir, byte[] buffer) throws IOException {
        String relativePath;
        String string = relativePath = rootFile.equals(fileOrDir) ? "" : fileOrDir.getPath().substring(rootFile.getPath().length() + 1);
        if (!File.separator.equals("/")) {
            relativePath = relativePath.replaceAll("\\\\", "/");
        }
        if (fileOrDir.isDirectory()) {
            File[] subFiles;
            if (this.includeFolders) {
                try {
                    out.putNextEntry(new ZipEntry(relativePath + "/"));
                }
                catch (ZipException e) {
                    log.fine("ZipCreator attempted to add duplicate entry \"" + fileOrDir + "\" to the zip file. This can probably be ignored");
                }
            }
            if ((subFiles = fileOrDir.listFiles(this.filter)) == null) {
                throw new RuntimeException("Could not get list of files for directory " + fileOrDir.getAbsolutePath());
            }
            out.closeEntry();
            for (File eachSubFile : subFiles) {
                this._zipRecursive(out, rootFile, eachSubFile, buffer);
            }
        } else if (fileOrDir.exists()) {
            ZipEntry zipEntry = new ZipEntry(this.includeFolders ? relativePath : fileOrDir.getName());
            zipEntry.setSize(fileOrDir.length());
            zipEntry.setTime(fileOrDir.lastModified());
            try {
                out.putNextEntry(zipEntry);
                try (FileInputStream input = new FileInputStream(fileOrDir);){
                    int lastBytesRead;
                    while ((lastBytesRead = input.read(buffer)) != -1) {
                        out.write(buffer, 0, lastBytesRead);
                    }
                }
                out.closeEntry();
                this.bytesWritten += fileOrDir.length();
                if (this.bytesWritten > this.maximumZipSize) {
                    throw new ZipException("Maximum zip size of " + this.maximumZipSize + " exceeded");
                }
            }
            catch (ZipException e) {
                log.fine("ZipCreator attempted to add duplicate entry \"" + fileOrDir + "\" to the zip file. In the case of DB downloads, this can probably be ignored");
            }
        } else {
            log.warning("File could not be zipped because it does not exist: " + fileOrDir.getAbsolutePath());
        }
    }
}

