/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.exception.UserCanceledException;
import com.prosc.infrastructure.Platform;
import com.prosc.io.IOUtils;
import com.prosc.io.ProcessExecutionException;
import com.prosc.shared.StringUtils;
import com.prosc.thread.MyThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class ProcessUtils {
    private static final Logger log = Logger.getLogger(ProcessUtils.class.getName());

    private ProcessUtils() {
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir) throws ProcessExecutionException, IOException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, true);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, boolean redirectStdErr) throws ProcessExecutionException, IOException, UserCanceledException {
        try {
            return ProcessUtils.doShellCommand(commandArray, env, workingDir, 0, redirectStdErr);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] doShellCommand(String[] commandArray, @Nullable Map<String, String> env, @Nullable File workingDir, int timeout) throws ProcessExecutionException, IOException, UserCanceledException, TimeoutException {
        return ProcessUtils.doShellCommand(commandArray, env, workingDir, timeout, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] doShellCommand(final String[] commandArray, final @Nullable Map<String, String> env, final @Nullable File workingDir, int timeout, final boolean redirectStdErr) throws ProcessExecutionException, IOException, TimeoutException, UserCanceledException {
        Callable<byte[]> callable = new Callable<byte[]>(){

            @Override
            public byte[] call() throws IOException, ProcessExecutionException, InterruptedException {
                String[] convertedCommands = new String[commandArray.length];
                for (int n = 0; n < commandArray.length; ++n) {
                    convertedCommands[n] = commandArray[n] == null ? "" : commandArray[n];
                }
                LinkedHashMap<String, String> envMap = new LinkedHashMap<String, String>(System.getenv());
                if (env != null) {
                    for (Map.Entry entry : env.entrySet()) {
                        envMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                ProcessBuilder builder = new ProcessBuilder(convertedCommands);
                if (workingDir != null) {
                    builder.directory(workingDir);
                }
                if (env != null) {
                    for (Map.Entry entry : envMap.entrySet()) {
                        builder.environment().put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                builder.redirectErrorStream(redirectStdErr);
                Process process = builder.start();
                try {
                    Throwable throwable = null;
                    try (InputStream inputStream = process.getInputStream();){
                        int n;
                        byte[] data;
                        Throwable throwable2;
                        InputStream errorStream;
                        block40: {
                            byte[] e22;
                            block41: {
                                block42: {
                                    errorStream = process.getErrorStream();
                                    throwable2 = null;
                                    data = IOUtils.inputStreamAsBytes(inputStream);
                                    try {
                                        n = process.waitFor();
                                    }
                                    catch (InterruptedException e22) {
                                        log.info("ProcessUtils was interrupted; destroying subprocess");
                                        process.destroy();
                                        log.info("Process " + process + " was destroyed");
                                        throw e22;
                                    }
                                    if (n != 0) break block40;
                                    e22 = data;
                                    if (errorStream == null) break block41;
                                    if (throwable2 == null) break block42;
                                    try {
                                        errorStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block41;
                                }
                                errorStream.close();
                            }
                            return e22;
                        }
                        try {
                            try {
                                try {
                                    String errReturned;
                                    String[] commandCopy = new String[commandArray.length];
                                    System.arraycopy(commandArray, 0, commandCopy, 0, commandArray.length);
                                    for (int m = 0; m < commandCopy.length; ++m) {
                                        if (commandCopy[m] == null || !commandCopy[m].toLowerCase().contains("pass") || m + 1 >= commandCopy.length) continue;
                                        commandCopy[m + 1] = "xxxxx";
                                    }
                                    String errorMessage = "Command " + Arrays.asList(commandCopy) + " failed with exit status " + n;
                                    if (data.length > 0) {
                                        errorMessage = errorMessage + "\nCommand output:\n" + new String(data, StandardCharsets.UTF_8).trim();
                                    }
                                    if (StringUtils.nonEmpty(errReturned = IOUtils.inputStreamAsString(errorStream, StandardCharsets.UTF_8))) {
                                        errorMessage = errorMessage + "\nError output: " + errReturned;
                                    }
                                    throw new ProcessExecutionException(data, errorMessage, n);
                                }
                                catch (Throwable throwable4) {
                                    throwable2 = throwable4;
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (errorStream != null) {
                                    if (throwable2 != null) {
                                        try {
                                            errorStream.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        errorStream.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                    }
                }
                finally {
                    process.destroy();
                }
            }
        };
        try {
            if (timeout <= 0) {
                return (byte[])callable.call();
            }
            ExecutorService service = Executors.newSingleThreadExecutor(new MyThreadFactory("ProcessUtils"));
            Future<byte[]> future = service.submit(callable);
            try {
                byte[] byArray = future.get(timeout, TimeUnit.MILLISECONDS);
                return byArray;
            }
            catch (TimeoutException e) {
                log.info("Process exceeded timeout; will cancel it.");
                future.cancel(true);
                throw e;
            }
            catch (InterruptedException e) {
                future.cancel(true);
                throw e;
            }
            finally {
                service.shutdown();
            }
        }
        catch (Throwable t) {
            if (t instanceof ExecutionException) {
                log.log(Level.WARNING, "Exception in ProcessUtils, stack trace up to this point: " + new RuntimeException("Stack trace only"));
                t = t.getCause();
            }
            if (t instanceof ProcessExecutionException) {
                throw (ProcessExecutionException)t;
            }
            if (t instanceof InterruptedException) {
                throw new UserCanceledException("User canceled '" + commandArray[0] + "' command", t);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof TimeoutException) {
                throw (TimeoutException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
            throw (RuntimeException)t;
        }
    }

    public static Collection<String> findPids(String processName, String commandSearch) throws TimeoutException {
        String[] lines;
        String[] cmd = Platform.isWin() ? new String[]{"wmic", "PROCESS", "where", "name like '%" + processName + "%'", "GET", "Processid,Caption,Commandline"} : new String[]{"ps", "axwww"};
        try {
            byte[] bytes = ProcessUtils.doShellCommand(cmd, null, null, 15000);
            String searchIn = new String(bytes, StandardCharsets.UTF_8);
            lines = searchIn.split(System.getProperty("line.separator"));
        }
        catch (TimeoutException e) {
            log.log(Level.SEVERE, "Process timed out: " + Arrays.asList(cmd), e);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String line : lines) {
            if (!line.contains(processName) || !line.contains(commandSearch)) continue;
            if (Platform.isWin()) {
                line = line.trim();
                result.add(line.substring(line.lastIndexOf(32) + 1));
                continue;
            }
            result.add(line.substring(0, line.indexOf(" ")));
        }
        return result;
    }

    public static String getJavaPath() {
        File result;
        String pathToExecutable = System.getenv("_RUNJAVA");
        if (pathToExecutable == null || !new File(pathToExecutable).exists()) {
            pathToExecutable = System.getenv("_EXECJAVA");
        }
        if (pathToExecutable == null || !new File(pathToExecutable).exists()) {
            String javaHome = System.getProperty("java.home");
            pathToExecutable = javaHome + File.separator + "bin" + File.separator + "java";
            if (Platform.isWin()) {
                pathToExecutable = pathToExecutable + ".exe";
            }
            if (!(result = new File(pathToExecutable)).exists()) {
                throw new IllegalStateException("No file found at " + pathToExecutable);
            }
        } else {
            result = new File(pathToExecutable);
        }
        if (result.canExecute()) {
            return result.getAbsolutePath();
        }
        throw new IllegalStateException("A file exists at '" + result.getPath() + "', but it is not executable");
    }
}

