/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InterruptibleOutputStream
extends FilterOutputStream {
    private static final Logger log = Logger.getLogger(InterruptibleOutputStream.class.getName());
    private boolean interrupted;
    protected volatile int bytesTransferred;

    public InterruptibleOutputStream(OutputStream out) {
        super(out);
    }

    public void interrupt() {
        this.interrupted = true;
    }

    private void checkInterruptStatus() throws InterruptedIOException {
        if (Thread.currentThread().isInterrupted()) {
            this.interrupt();
        }
        if (this.interrupted) {
            log.log(Level.INFO, this.toString() + " interrupted!");
            InterruptedIOException interruptedIOException = new InterruptedIOException("Interrupted");
            interruptedIOException.bytesTransferred = this.bytesTransferred;
            throw interruptedIOException;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkInterruptStatus();
        super.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkInterruptStatus();
        super.write(b);
        ++this.bytesTransferred;
    }

    public synchronized int getBytesTransferred() {
        return this.bytesTransferred;
    }
}

