/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.format.ByteLengthFormat;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputStreamRangeModel
extends FilterInputStream
implements BoundedRangeModel {
    private static final Logger log = Logger.getLogger(InputStreamRangeModel.class.getName());
    private final EventListenerList changeListeners = new EventListenerList();
    private final int zoomFactor;
    private Level logLevel = Level.FINE;
    private boolean valueIsAdjusting;
    private long extent;
    private long maximum;
    private long position = 0L;
    private long nextUpdate;
    private long startedRead;
    private boolean finished = false;
    private final NumberFormat percent;
    private long logMinDelay = -1L;
    private long nextLogUpdate = -1L;
    private String statusMessage = null;

    public InputStreamRangeModel(InputStream in) throws IOException {
        this(in, in.available());
    }

    public InputStreamRangeModel(InputStream in, long length) {
        super(in);
        this.zoomFactor = length > Integer.MAX_VALUE ? (int)Math.ceil((double)length / 2.147483647E9) : 1;
        this.maximum = length;
        this.nextUpdate = this.extent = this.maximum / 100L;
        this.percent = NumberFormat.getPercentInstance();
        this.percent.setMaximumFractionDigits(0);
        this.startedRead = System.currentTimeMillis();
        log.finest("--> InputStreamRangeModel " + System.identityHashCode(this) + " was created");
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMinimum(int newMinimum) {
        if (newMinimum != 0) {
            this.ignoreMutation();
        }
    }

    @Override
    public synchronized int getMaximum() {
        return (int)(this.maximum / (long)this.zoomFactor);
    }

    @Override
    public synchronized void setMaximum(int newMaximum) {
        this.maximum = newMaximum;
    }

    @Override
    public synchronized int getValue() {
        return (int)(this.position / (long)this.zoomFactor);
    }

    @Override
    public void setValue(int newValue) {
        this.ignoreMutation();
    }

    @Override
    public synchronized void setValueIsAdjusting(boolean b) {
        this.valueIsAdjusting = b;
    }

    @Override
    public synchronized boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public synchronized int getExtent() {
        return (int)(this.extent / (long)this.zoomFactor);
    }

    @Override
    public synchronized void setExtent(int newExtent) {
        this.extent = newExtent;
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.ignoreMutation();
    }

    @Override
    public synchronized void addChangeListener(ChangeListener x) {
        this.changeListeners.add(ChangeListener.class, x);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener x) {
        this.changeListeners.remove(ChangeListener.class, x);
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.startedRead == -1L) {
            this.startedRead = System.currentTimeMillis();
        }
        if ((result = super.read()) == -1) {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        } else {
            this.reposition(1L);
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int result;
        if (this.startedRead == -1L) {
            this.startedRead = System.currentTimeMillis();
        }
        if ((result = super.read(b, off, len)) == -1) {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        } else {
            this.reposition(result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(n);
        this.reposition(result);
        return result;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        log.finest("<-- InputStreamRangeModel " + System.identityHashCode(this) + " was closed");
        Object[] list = this.changeListeners.getListenerList();
        Object[] listenersToRemove = new Object[list.length];
        System.arraycopy(list, 0, listenersToRemove, 0, listenersToRemove.length);
        for (int i = listenersToRemove.length - 2; i >= 0; i -= 2) {
            this.changeListeners.remove((Class)listenersToRemove[i], (EventListener)listenersToRemove[i + 1]);
        }
        try {
            super.close();
        }
        finally {
            if (!this.finished) {
                this.finished = true;
                this.streamFinished();
            }
        }
    }

    public void setLogging(Level logLevel, @Nullable Integer minDelay) {
        this.logLevel = logLevel;
        this.logMinDelay = minDelay == null ? -1L : (long)minDelay.intValue();
    }

    public synchronized int getBytesPerSecond() {
        long duration = System.currentTimeMillis() - this.startedRead;
        if (this.startedRead == -1L || duration == 0L) {
            return 0;
        }
        return (int)(this.position * 1000L / duration);
    }

    public synchronized String getStatusMessage() {
        return this.statusMessage;
    }

    public synchronized Long getEstimatedTimeRemaining() {
        if (this.startedRead == -1L) {
            return null;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.startedRead;
        float finishedFraction = (float)this.position / (float)this.maximum;
        long projectedTotalTime = (long)((float)elapsed / finishedFraction);
        float remainingFraction = 1.0f - finishedFraction;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Elapsed: " + elapsed + " / position: " + this.position + " / maximum: " + this.maximum + " / finishedFraction: " + finishedFraction + " / projectedTotalTime: " + projectedTotalTime + " / remainingFraction: " + remainingFraction + " / result " + (long)((float)projectedTotalTime * remainingFraction));
        }
        return (long)((float)projectedTotalTime * remainingFraction);
    }

    protected void streamFinished() {
    }

    private synchronized void reposition(long i) {
        this.position += i;
        if (!this.valueIsAdjusting && this.position >= this.nextUpdate) {
            boolean finished;
            boolean bl = finished = this.position == this.maximum;
            if (finished || System.currentTimeMillis() >= this.nextLogUpdate) {
                if (finished) {
                    long milliseconds = System.currentTimeMillis() - this.startedRead;
                    this.statusMessage = "100% complete; streamed " + this.position + " bytes in " + milliseconds + " milliseconds; bytes per second: " + new ByteLengthFormat().format(this.getBytesPerSecond()) + "; Total time elapsed: " + Math.round((float)milliseconds / 1000.0f) + " seconds";
                    log.log(this.logLevel, this.statusMessage);
                } else {
                    String msg = this.percent.format((float)this.position / (float)this.maximum) + " complete; bytes per second: " + new ByteLengthFormat().format(this.getBytesPerSecond());
                    Long estimatedTimeRemaining = this.getEstimatedTimeRemaining();
                    if (estimatedTimeRemaining != null) {
                        msg = msg + "; estimated time remaining: " + new DecimalFormat("#,###").format(estimatedTimeRemaining / 1000L) + " seconds";
                    }
                    this.statusMessage = msg;
                }
                if (this.logMinDelay != -1L) {
                    this.nextLogUpdate = System.currentTimeMillis() + this.logMinDelay;
                }
                if (log.isLoggable(this.logLevel)) {
                    log.log(this.logLevel, this.statusMessage);
                }
            }
            this.nextUpdate += this.extent;
            if (this.changeListeners.getListenerCount() > 0) {
                Runnable runnable = () -> {
                    ChangeEvent event = new ChangeEvent(this);
                    Object[] array = this.changeListeners.getListenerList();
                    for (int i1 = array.length - 2; i1 >= 0; i1 -= 2) {
                        if (array[i1] != ChangeListener.class) continue;
                        ((ChangeListener)array[i1 + 1]).stateChanged(event);
                    }
                };
                if (GraphicsEnvironment.isHeadless() || EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    EventQueue.invokeLater(runnable);
                }
            }
        }
    }

    private void ignoreMutation() {
        log.log(Level.WARNING, "Ignored attempt to modify InputStreamRangeModel", new RuntimeException("Stack trace only"));
    }
}

