/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.io;

import com.prosc.shared.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FileType {
    unknown("application/unknown", false, "dat"),
    binary("application/octet-stream", false, "bin", "exe"),
    png("image/png", true, "png"),
    jpeg("image/jpeg", true, "jpg", "jpeg"),
    gif("image/gif", true, "gif"),
    tiff("image/tiff", false, "tif", "tiff"),
    mpeg4audio("audio/mp4", true, "m4a"),
    mpeg4video("video/mp4", true, "mp4"),
    mpegVideo("video/mpeg", true, "mpeg"),
    mpeg3(new String[]{"audio/mp3", "audio/mpeg"}, true, "mp3"),
    mov("video/quicktime", true, "mov"),
    html("text/html", false, "htm", "html"),
    css("text/css", false, "css"),
    scss("text/x-scss", false, "scss"),
    javascript("application/javascript", "js"),
    plaintext("text/plain", false, "txt"),
    json("application/json", false, "json"),
    map("application/x-navimap", false, "map"),
    markdown("text/markdown", false, "md"),
    csv("text/csv", "csv"),
    pdf("application/pdf", false, "pdf"),
    doc("application/msword", false, "doc"),
    docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document", true, "docx", "docm", "dotx", "dotm"),
    xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", true, "xlsx"),
    pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation", true, "pptx"),
    fp7("application/x-filemaker", false, "fp7"),
    fmp12("application/x-filemaker", false, "fmp12"),
    zip("application/zip", true, "zip"),
    gzip(new String[]{"application/gzip", "application/x-gzip"}, true, "gzip"),
    jar("application/java-archive", true, "jar"),
    war("application/java-archive", true, "war"),
    rar("application/x-compressed", true, "rar"),
    opentypefont("application/vnd.ms-fontobject", "eot"),
    outlinefont("application/font-sfnt ", "otf"),
    svg("image/svg+xml", "svg"),
    truetypefont("application/font-sfnt", "ttf"),
    woff("application/font-woff", "woff"),
    woff2("font/woff2", "woff2");

    private static final Logger log;
    private final List<String> mimeTypes;
    private final List<String> extensions;
    private final boolean compressed;

    private FileType(String mimeType, String ... extensions) {
        this(mimeType, false, extensions);
    }

    private FileType(String mimeType, boolean compressed, String ... extensions) {
        this.mimeTypes = Collections.singletonList(mimeType.toLowerCase().trim());
        this.compressed = compressed;
        this.extensions = Arrays.asList(extensions);
    }

    private FileType(String[] mimeTypes, boolean compressed, String ... extensions) {
        this.mimeTypes = Arrays.stream(mimeTypes).map(eachType -> eachType.toLowerCase().trim()).collect(Collectors.toList());
        this.compressed = compressed;
        this.extensions = Arrays.asList(extensions);
    }

    public String getPrimaryExtension() {
        return this.extensions.get(0);
    }

    public String getMimeType() {
        return this.mimeTypes.get(0);
    }

    @NotNull
    public static FileType fileTypeForFileName(String filename) {
        if (!filename.endsWith("/")) {
            String suffix = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
            for (FileType fileType : FileType.values()) {
                if (!fileType.extensions.contains(suffix)) continue;
                return fileType;
            }
            log.info("Could not determine file type for '" + filename + "'; will use binary");
        }
        return binary;
    }

    @NotNull
    public static FileType fileTypeForMimeType(@Nullable String mimeType) {
        if (!StringUtils.isEmpty(mimeType, true)) {
            String compareTo = StringUtils.textBefore(mimeType.toLowerCase().trim(), ";", true);
            for (FileType value : FileType.values()) {
                if (!value.mimeTypes.contains(compareTo)) continue;
                return value;
            }
        }
        return unknown;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    static {
        log = Logger.getLogger(FileType.class.getName());
    }
}

