/*
 * Decompiled with CFR 0.152.
 */
package com.prosc.infrastructure;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public enum Platform {
    mac(true),
    windows(false),
    linux(true),
    unknown(true);

    public static final Platform current;
    public final boolean unixLike;

    private Platform(boolean unixLike) {
        this.unixLike = unixLike;
    }

    public static boolean isMac() {
        return current == mac;
    }

    public static boolean isWin() {
        return current == windows;
    }

    public static boolean isLin() {
        return current == linux;
    }

    public String pathTranslated(@NotNull String pathFromOtherPlatform) {
        Platform origin = Platform.analyzePath(pathFromOtherPlatform);
        if (origin == this) {
            return pathFromOtherPlatform;
        }
        switch (origin) {
            case unknown: {
                return pathFromOtherPlatform;
            }
            case mac: 
            case linux: {
                if (this == windows) {
                    String backslashed = pathFromOtherPlatform.replace("\\", ":").replace("/", "\\");
                    return backslashed.substring(1).replaceFirst("\\\\", ":\\\\");
                }
                return pathFromOtherPlatform;
            }
            case windows: {
                return "/" + pathFromOtherPlatform.replace("/", ":").replace("\\", "/").replaceFirst("\\:/", "/");
            }
        }
        return pathFromOtherPlatform;
    }

    @NotNull
    private static Platform analyzePath(@NotNull String pathFromOtherPlatform) {
        if (pathFromOtherPlatform.startsWith("/")) {
            return mac;
        }
        if (pathFromOtherPlatform.contains(":\\")) {
            return windows;
        }
        return unknown;
    }

    public static File getApplicationDataDirForUser() {
        if (Platform.isMac()) {
            return new File(System.getProperty("user.home"), "Library/Application Support");
        }
        if (Platform.isWin()) {
            return new File(System.getenv("APPDATA"));
        }
        if (Platform.isLin()) {
            return new File(System.getProperty("user.home"));
        }
        throw new IllegalStateException("Unrecognized platform");
    }

    public static File getApplicationDataDirForSystem() {
        if (Platform.isMac()) {
            return new File("/Library/Application Support");
        }
        if (Platform.isWin()) {
            return new File(System.getenv("PROGRAMDATA"));
        }
        if (Platform.isLin()) {
            return new File(System.getProperty("user.home"));
        }
        throw new IllegalStateException("Unrecognized platform");
    }

    static {
        String osName = System.getProperty("os.name");
        current = osName == null ? unknown : (osName.startsWith("Mac") ? mac : (osName.startsWith("Windows") ? windows : (osName.startsWith("Linux") ? linux : unknown)));
    }
}

